<?php

namespace Tests\Feature;

use App\Models\Project;
use App\Models\User;
use Illuminate\Foundation\Testing\RefreshDatabase;
use Illuminate\Testing\TestResponse;
use Tests\TestCase;

class ProjectStoreTest extends TestCase
{
    use RefreshDatabase;

    protected User $user;

    public function setUp(): void
    {
        parent::setUp();

        $this->user = User::factory()->create();
    }

    protected function storeProject($data = []): TestResponse
    {
        return $this->actingAs($this->user)
            ->postJson(route('projects.store', $data));
    }

    public function testUnverifiedUserCannotStoreProject(): void
    {
        $this->user->update(['email_verified_at' => null]);

        $response = $this->storeProject();

        $response->assertForbidden();
    }

    public function testFieldsAreRequired(): void
    {
        $response = $this->storeProject();

        $response->assertInvalid([
            'name' => __('validation.required', ['attribute' => 'name']),
        ]);
    }

    // public function testNameIsUnique(): void
    // {
    //     $project = Project::factory()->create();

    //     $project->users()->attach($this->user, ['role' => 'admin']);

    //     $response = $this->storeProject(['name' => $project->name]);
    //     dd($response->json());
    //     $response->assertInvalid([
    //         'name' => __('validation.unique', ['attribute' => 'name']),
    //     ]);
    // }

    public function testProjectWasCreated(): void
    {
        $name = fake()->catchPhrase();

        $response = $this->storeProject(['name' => $name]);

        $response->assertValid();

        $response->assertJson([
            'data' => [
                'id' => $response->json('data.id'),
                'name' => $name,
                'created_at' => $response->json('data.created_at'),
            ],
        ]);

        $this->assertDatabaseHas('projects', [
            'id' => $response->json('data.id'),
            'name' => $name,
        ]);
    }
}
