<?php

namespace Tests\Feature;

use App\Models\Project;
use App\Models\User;
use Illuminate\Foundation\Testing\RefreshDatabase;
use Illuminate\Testing\TestResponse;
use Tests\TestCase;

class ProjectIndexTest extends TestCase
{
    use RefreshDatabase;

    protected User $user;

    public function setUp(): void
    {
        parent::setUp();

        $this->user = User::factory()->create();
    }

    protected function getProjects($page = 1): TestResponse
    {
        return $this->actingAs($this->user)
            ->getJson(route('projects.index', ['page' => $page]));
    }

    public function testProjectsListed(): void
    {
        Project::factory()->count(2)->create();

        $projects = Project::factory()->count(5)->create();

        $this->user->projects()->sync($projects->map->id);

        $response = $this->getProjects();

        $response->assertJson([
            'meta' => [
                'current_page' => 1,
                'total' => 5,
                'per_page' => 12,
            ],
        ]);
    }

    public function testProjectListedSecondPage(): void
    {
        $projects = Project::factory()->count(15)->create();

        $this->user->projects()->sync($projects->map->id);

        $response = $this->getProjects(2);

        $response->assertJson([
            'meta' => [
                'current_page' => 2,
                'total' => 15,
                'per_page' => 12,
            ],
        ]);
    }
}
