<?php

namespace Tests\Feature;

use App\Models\KeyDriver;
use App\Models\Project;
use App\Models\User;
use Illuminate\Foundation\Testing\RefreshDatabase;
use Illuminate\Testing\TestResponse;
use Tests\TestCase;

class KeyDriverIndexTest extends TestCase
{
    use RefreshDatabase;

    protected User $user;

    protected Project $project;

    public function setUp(): void
    {
        parent::setUp();

        $this->user = User::factory()->create();

        $this->project = Project::factory()->create();

        $this->user->projects()->attach($this->project, ['role' => 'admin']);
    }

    protected function getDrivers($page = 1): TestResponse
    {
        return $this->actingAs($this->user)
            ->getJson(
                route(
                    'projects.drivers.index',
                    [
                        'project' => $this->project,
                        'page' => $page,
                    ],
                ),
            );
    }

    public function testProjectNotFound(): void
    {
        $this->project->delete();

        $response = $this->getDrivers();

        $response->assertNotFound();
    }

    public function testProjectExistButUserIsNotCollaborator(): void
    {
        $this->user->projects()->detach($this->project);

        $response = $this->getDrivers();

        $response->assertNotFound();
    }

    public function testDriversListed(): void
    {
        KeyDriver::factory()->count(2)->create();

        $drivers = KeyDriver::factory()->count(5)->make();

        $this->project->drivers()->createMany($drivers->toArray());

        $response = $this->getDrivers();

        $this->assertCount(5, $response->json('data'));
    }
}
