<?php

namespace Tests\Feature;

use App\Models\User;
use Illuminate\Auth\Notifications\VerifyEmail;
use Illuminate\Foundation\Testing\RefreshDatabase;
use Illuminate\Support\Facades\Notification;
use Illuminate\Testing\TestResponse;
use Tests\TestCase;

class EmailNotifyTest extends TestCase
{
    use RefreshDatabase;

    protected function sendEmail(): TestResponse
    {
        return $this->postJson(route('verification.notify'));
    }

    public function testEmailAlreadyVerified(): void
    {
        Notification::fake();

        $user = User::factory()->create();

        $response = $this->actingAs($user)->sendEmail();

        $response->assertJson(['message' => 'Your email is already verified.']);

        Notification::assertNothingSent();
    }

    public function testNotificationSent(): void
    {
        Notification::fake();

        $user = User::factory()->create(['email_verified_at' => null]);

        $response = $this->actingAs($user)->sendEmail();

        $response->assertJson(['message' => 'We send you an email with the verification link, please check your inbox.']);

        Notification::assertSentTo($user, VerifyEmail::class);
    }
}
