<?php

use App\Http\Controllers\AccountController;
use App\Http\Controllers\AuthController;
use App\Http\Controllers\DriverItemController;
use App\Http\Controllers\DriverItemGraphicController;
use App\Http\Controllers\EmailVerificationController;
use App\Http\Controllers\ItemRecordController;
use App\Http\Controllers\ItemRecordsController;
use App\Http\Controllers\KeyDriverController;
use App\Http\Controllers\PasswordController;
use App\Http\Controllers\ProjectController;
use App\Http\Controllers\ProjectUserController;
use App\Http\Controllers\UserController;
use Illuminate\Support\Facades\Route;

Route::controller(AuthController::class)->group(function () {
    Route::post('/signin', 'signIn')->name('auth.signin');
    Route::post('/signup', 'signUp')->name('auth.signup');
});

Route::controller(PasswordController::class)->group(function () {
    Route::post('/password/forgot', 'forgot')->name('password.forgot');
    Route::post('/password/reset', 'reset')->name('password.reset');
});

Route::controller(EmailVerificationController::class)->group(function () {
    Route::get('/email/verify/{id}/{hash}', 'verify')->name('verification.verify');
    Route::post('/email/notify', 'notify')->name('verification.notify');
});

Route::controller(AccountController::class)->group(function () {
    Route::get('/account', 'show')->name('account.show');
    Route::put('/account', 'update')->name('account.update');
    Route::put('/account/password', 'updatePassword')->name('account.password');
});

Route::controller(UserController::class)->group(function () {
    Route::get('/users', 'index')->name('users.index');
});

Route::controller(ProjectController::class)->group(function () {
    Route::get('/projects', 'index')->name('projects.index');
    Route::get('/projects/{project}', 'show')->name('projects.show');
    Route::post('/projects', 'store')->name('projects.store');
    Route::put('/projects/{project}', 'update')->name('projects.update');
    Route::delete('/projects/{project}', 'delete')->name('projects.delete');
});

Route::controller(ProjectUserController::class)->scopeBindings()->group(function () {
    Route::get('/projects/{project}/users', 'index')->name('projects.users.index');
    Route::post('/projects/{project}/users', 'store')->name('projects.users.store');
    Route::delete('/projects/{project}/users/{user}', 'delete')->name('projects.users.delete');
});

Route::controller(KeyDriverController::class)->scopeBindings()->group(function () {
    Route::get('/projects/{project}/drivers', 'index')->name('projects.drivers.index');
    Route::get('/projects/{project}/drivers/{driver}', 'show')->name('projects.drivers.show');
    Route::post('/projects/{project}/drivers', 'store')->name('projects.drivers.store');
    Route::put('/projects/{project}/drivers/{driver}', 'update')->name('projects.drivers.update');
    Route::delete('/projects/{project}/drivers/{driver}', 'delete')->name('projects.drivers.delete');
});

Route::controller(DriverItemController::class)->scopeBindings()->group(function () {
    Route::get('/projects/{project}/drivers/{driver}/items', 'index')->name('projects.drivers.items.index');
    Route::get('/projects/{project}/drivers/{driver}/items/{item}', 'show')->name('projects.drivers.items.show');
    Route::post('/projects/{project}/drivers/{driver}/items', 'store')->name('projects.drivers.items.store');
    Route::put('/projects/{project}/drivers/{driver}/items/{item}', 'update')->name('projects.drivers.items.update');
    Route::delete('/projects/{project}/drivers/{driver}/items/{item}', 'delete')->name('projects.drivers.items.delete');
});

Route::controller(DriverItemGraphicController::class)->scopeBindings()->group(function () {
    Route::get('/projects/{project}/summary', 'summary')->name('projects.summary');
    Route::get('/projects/{project}/drivers/{driver}/items/{item}/graphics/line', 'line')->name('projects.drivers.items.graphics.line');
});

Route::controller(ItemRecordsController::class)->scopeBindings()->group(function () {
    Route::get('/projects/{project}/drivers/{driver}/items/{item}/records/export', 'export')->name('projects.drivers.items.records.export');
    Route::post('/projects/{project}/drivers/{driver}/items/{item}/records/import', 'import')->name('projects.drivers.items.records.import');
});

Route::controller(ItemRecordController::class)->scopeBindings()->group(function () {
    Route::get('/projects/{project}/drivers/{driver}/items/{item}/records', 'index')->name('projects.drivers.items.records.index');
    Route::get('/projects/{project}/drivers/{driver}/items/{item}/records/{record}', 'show')->name('projects.drivers.items.records.show');
    Route::post('/projects/{project}/drivers/{driver}/items/{item}/records', 'store')->name('projects.drivers.items.records.store');
    Route::put('/projects/{project}/drivers/{driver}/items/{item}/records/{record}', 'update')->name('projects.drivers.items.records.update');
    Route::delete('/projects/{project}/drivers/{driver}/items/{item}/records/{record}', 'delete')->name('projects.drivers.items.records.delete');
});
