<?php

namespace Database\Seeders;

use App\Models\User;
use Illuminate\Database\Seeder;
use Illuminate\Support\Arr;
use Illuminate\Support\Facades\Hash;

class DatabaseSeeder extends Seeder
{
    public function run(): void
    {
        $user = User::create([
            'first_name' => 'Javier',
            'last_name' => 'Estupinan',
            'email' => 'jestupinan@zeerbyte.com',
            'email_verified_at' => now(),
            'role' => 'user',
            'password' => Hash::make('utwentepsdm'),
        ]);

        $project = $user->projects()->create(['name' => 'PSDM Test'], ['role' => 'owner']);

        $driver = $project->drivers()->create(['name' => 'Performance']);

        $item = $driver->items()->create([
            'name' => 'Satisfaction',
            'range' => false,
            'max' => 100,
            'min' => 0,
        ]);

        $item->records()->createMany([
            [
                'date' => now()->startOfDay()->subDays(2),
                'max' => 80,
                'min' => null,
                'type' => Arr::random(['normal', 'decision', 'risk', 'constraint', 'test']),
            ],
            [
                'date' => now()->startOfDay()->subDays(),
                'max' => 90,
                'min' => null,
                'type' => Arr::random(['normal', 'decision', 'risk', 'constraint', 'test']),
                'comments' => 'Everything is going smoothly',
            ],
            [
                'date' => now()->startOfDay(),
                'max' => 60,
                'min' => null,
                'type' => Arr::random(['normal', 'decision', 'risk', 'constraint', 'test']),
                'comments' => 'We are going down',
                'attachments' => [
                    'https://picsum.photos/id/237/200',
                    'https://picsum.photos/id/582/200',
                ],
            ],
            [
                'date' => now()->startOfDay()->addDays(),
                'max' => 80,
                'min' => null,
                'type' => Arr::random(['normal', 'decision', 'risk', 'constraint', 'test']),
            ],
            [
                'date' => now()->startOfDay()->addDays(2),
                'max' => 90,
                'min' => null,
                'type' => Arr::random(['normal', 'decision', 'risk', 'constraint', 'test']),
                'comments' => 'Everything is going smoothly',
            ],
            [
                'date' => now()->startOfDay()->addDays(3),
                'max' => 60,
                'min' => null,
                'type' => Arr::random(['normal', 'decision', 'risk', 'constraint', 'test']),
                'comments' => 'We are going down',
                'attachments' => [
                    'https://picsum.photos/id/237/200',
                    'https://picsum.photos/id/582/200',
                ],
            ],
        ]);

        $item2 = $driver->items()->create([
            'name' => 'Income',
            'range' => true,
            'max' => null,
            'min' => null,
        ]);

        $item2->records()->createMany([
            [
                'date' => now()->startOfDay()->subDays(2),
                'max' => 1560,
                'min' => 1250,
                'type' => Arr::random(['normal', 'decision', 'risk', 'constraint', 'test']),
                'comments' => 'We are going down',
            ],
            [
                'date' => now()->startOfDay()->subDays(),
                'max' => 10890,
                'min' => 9420,
                'type' => Arr::random(['normal', 'decision', 'risk', 'constraint', 'test']),
                'comments' => 'Everything is going smoothly',
                'attachments' => [
                    'https://picsum.photos/id/237/200',
                    'https://picsum.photos/id/582/200',
                ],
            ],
            [
                'date' => now()->startOfDay(),
                'max' => 5720,
                'min' => 3280,
                'type' => Arr::random(['normal', 'decision', 'risk', 'constraint', 'test']),
            ],
            [
                'date' => now()->startOfDay()->addDays(),
                'max' => 1560,
                'min' => 1250,
                'type' => Arr::random(['normal', 'decision', 'risk', 'constraint', 'test']),
                'comments' => 'We are going down',
            ],
            [
                'date' => now()->startOfDay()->addDays(2),
                'max' => 10890,
                'min' => 9420,
                'type' => Arr::random(['normal', 'decision', 'risk', 'constraint', 'test']),
                'comments' => 'Everything is going smoothly',
                'attachments' => [
                    'https://picsum.photos/id/237/200',
                    'https://picsum.photos/id/582/200',
                ],
            ],
            [
                'date' => now()->startOfDay()->addDays(3),
                'max' => 5720,
                'min' => 3280,
                'type' => Arr::random(['normal', 'decision', 'risk', 'constraint', 'test']),
            ],
        ]);
    }
}
