<?php

namespace App\Providers;

// use Illuminate\Support\Facades\Gate;

use Illuminate\Auth\Notifications\ResetPassword;
use Illuminate\Auth\Notifications\VerifyEmail;
use Illuminate\Foundation\Support\Providers\AuthServiceProvider as ServiceProvider;
use Illuminate\Notifications\Messages\MailMessage;

class AuthServiceProvider extends ServiceProvider
{
    protected $policies = [
        //
    ];

    public function boot(): void
    {
        $this->registerPolicies();

        ResetPassword::createUrlUsing(function (object $notifiable, string $token) {
            return config('app.frontend_url').'/password/reset/'.$token.'?email='.$notifiable->getEmailForPasswordReset();
        });

        VerifyEmail::toMailUsing(function (object $notifiable, string $url) {
            $newUrl = config('app.frontend_url');
            $newUrl .= '/email/verify/'.$notifiable->id.'/';
            $newUrl .= basename($url);

            $intro = 'Your email was changed recently. Please click the button below to verify your email.';

            if ($notifiable->wasRecentlyCreated) {
                $intro = 'A new account was created for you. Please click the button below to verify your email.';
            }

            return (new MailMessage())
                ->subject('Email Verification')
                ->greeting('Email Verification')
                ->line($intro)
                ->action('Verify Email', $newUrl)
                ->line('Thank you for using our application!');
        });
    }
}
