<?php

namespace App\Notifications;

use App\Models\Project;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Notifications\Messages\MailMessage;
use Illuminate\Notifications\Notification;

class ProjectDeleted extends Notification implements ShouldQueue
{
    use Queueable;

    public function __construct(protected Project $project)
    {
    }

    public function via(object $notifiable): array
    {
        return ['mail'];
    }

    public function toMail(object $notifiable): MailMessage
    {
        return (new MailMessage)
            ->subject('Project Deleted')
            ->greeting('Hi '.$notifiable->first_name.'!')
            ->line('The project "'.$this->project->name.'", which you are registred as collaborator, was permanently removed from the PSDM application.')
            ->line('Thank you for using our application!');
    }
}
