<?php

namespace App\Http\Resources;

use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class ItemRecordResource extends JsonResource
{
    public function toArray(Request $request): array
    {
        return [
            'id' => $this->id,
            'driver_item_id' => $this->driver_item_id,
            'date' => $this->date->format('Y-m-d'),
            'max' => $this->max,
            'min' => $this->min,
            'type' => $this->type,
            'comments' => $this->comments,
            'attachments' => $this->attachments,
        ];
    }
}
