<?php

namespace App\Http\Requests;

use App\Models\User;
use App\Notifications\ProjectUserAddded;
use Illuminate\Foundation\Http\FormRequest;

class ProjectUserStore extends FormRequest
{
    public function authorize(): bool
    {
        $user = $this->project->users()->find($this->user()->id);

        return $user->hasVerifiedEmail() && ($user->pivot->role === 'owner' || $user->pivot->role === 'admin');
    }

    public function rules(): array
    {
        return [
            'user_id' => ['required', 'exists:users,id'],
            'role' => ['required', 'in:user,admin'],
        ];
    }

    public function addUser(): User
    {
        $user = User::find($this->input('user_id'));

        $this->project->users()->attach($user, ['role' => $this->input('role')]);

        $user->notify(new ProjectUserAddded($this->project));

        return $user;
    }
}
