<?php

namespace App\Http\Requests;

use App\Models\Project;
use Illuminate\Foundation\Http\FormRequest;

class ProjectUpdate extends FormRequest
{
    public function authorize(): bool
    {
        $user = $this->project->users()->find($this->user()->id);

        return $user->hasVerifiedEmail() && ($user->pivot->role === 'owner' || $user->pivot->role === 'admin');
    }

    public function rules(): array
    {
        return [
            'name' => ['required', 'string', 'max:255'],
        ];
    }

    public function updateProject(): Project
    {
        $project = $this->user()->projects()->find($this->project->id);

        $project->update($this->validated());

        return $project;
    }
}
