<?php

namespace App\Http\Requests;

use Illuminate\Database\Query\Builder;
use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Validation\Rule;

class KeyDriverUpdate extends FormRequest
{
    public function authorize(): bool
    {
        $user = $this->project->users()->find($this->user()->id);

        return $user->hasVerifiedEmail() && ($user->pivot->role === 'owner' || $user->pivot->role === 'admin');
    }

    public function rules(): array
    {
        return [
            'name' => [
                'required',
                'string',
                'max:255',
                Rule::unique('key_drivers')->where(function (Builder $query) {
                    $query->where('project_id', $this->project->id)
                        ->where('id', '<>', $this->driver->id);
                }),
            ],
        ];
    }

    public function updateDriver(): void
    {
        $this->driver->update($this->validated());
    }
}
