<?php

namespace App\Http\Controllers;

use App\Http\Resources\UserResource;
use App\Models\User;
use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\AnonymousResourceCollection;

class UserController extends Controller
{
    public function __construct()
    {
        $this->middleware('auth');
    }

    public function index(Request $request): AnonymousResourceCollection
    {
        $perPage = (int) $request->get('per_page');

        $users = User::where('id', '<>', $request->user()->id)
            ->whereSearch($request->get('search'))
            ->whereNotInProject($request->get('project_id'))
            ->orderByName()
            ->paginate($perPage > 0 ? $perPage : 12);

        return UserResource::collection($users);
    }
}
