<?php

namespace App\Http\Controllers;

use App\Http\Requests\ItemRecordsImport;
use App\Models\DriverItem;
use App\Models\KeyDriver;
use App\Models\Project;
use Illuminate\Support\Str;
use Symfony\Component\HttpFoundation\StreamedResponse;

class ItemRecordsController extends Controller
{
    public function __construct()
    {
        $this->middleware('auth');
    }

    public function export(Project $project, KeyDriver $driver, DriverItem $item): StreamedResponse
    {
        $records = $item->records()->orderBy('date', 'desc')->get();

        $fileName = Str::slug($item->name).'.csv';

        $columns = ['Date', 'Max', 'Min', 'Type', 'Comments'];

        return response()->streamDownload(function () use ($records, $columns) {
            $file = fopen('php://output', 'w');

            fputcsv($file, $columns);

            foreach ($records as $record) {
                $row['Date'] = $record->date->toDateString();
                $row['Max'] = $record->max;
                $row['Min'] = is_null($record->min) ? '' : $record->min;
                $row['Type'] = $record->type;
                $row['Comments'] = $record->comments;

                fputcsv(
                    $file,
                    [
                        $row['Date'],
                        $row['Max'],
                        $row['Min'],
                        $row['Type'],
                        $row['Comments'],
                    ],
                );
            }

            fclose($file);
        }, $fileName, ['Content-Type' => 'text/csv']);
    }

    public function import(Project $project, KeyDriver $driver, DriverItem $item, ItemRecordsImport $request)
    {
        $count = $request->saveData();

        return response()->json(['message' => $count.' records were successfully saved.']);
    }
}
