<?php

namespace Tests\Feature;

use App\Models\User;
use Illuminate\Auth\Events\Logout;
use Illuminate\Foundation\Testing\RefreshDatabase;
use Illuminate\Support\Facades\Event;
use Illuminate\Testing\TestResponse;
use Tests\TestCase;

class SignOutTest extends TestCase
{
    use RefreshDatabase;

    protected function signOut(): TestResponse
    {
        return $this->postJson(route('auth.signout'));
    }

    public function testUserSignedOut(): void
    {
        Event::fake();

        $user = User::factory()->create();

        $response = $this->actingAs($user)->signOut();

        $response->assertJson(['message' => 'See you back soon!']);

        $this->assertGuest();

        Event::assertDispatched(Logout::class);
    }
}
