<?php

namespace Tests\Feature;

use App\Models\Project;
use App\Models\User;
use Illuminate\Foundation\Testing\RefreshDatabase;
use Illuminate\Testing\TestResponse;
use Tests\TestCase;

class ProjectShowTest extends TestCase
{
    use RefreshDatabase;

    protected User $user;

    protected Project $project;

    public function setUp(): void
    {
        parent::setUp();

        $this->user = User::factory()->create();

        $this->project = Project::factory()
            ->hasAttached($this->user, ['role' => 'owner'])
            ->create();
    }

    protected function getProject(): TestResponse
    {
        return $this->actingAs($this->user)
            ->getJson(route('projects.show', ['project' => $this->project]));
    }

    public function testProjectNotFound(): void
    {
        $this->project->delete();

        $response = $this->getProject();

        $response->assertNotFound();
    }

    public function testProjectExistButUserIsNotCollaborator(): void
    {
        $this->user->projects()->detach($this->project);

        $response = $this->getProject();

        $response->assertNotFound();
    }

    public function testProjectFound(): void
    {
        $response = $this->getProject();

        $response->assertJson([
            'data' => [
                'id' => $this->project->id,
                'name' => $this->project->name,
                'created_at' => $this->project->created_at->toJson(),
            ],
        ]);
    }
}
