<?php

namespace Tests\Feature;

use App\Models\User;
use Illuminate\Foundation\Testing\RefreshDatabase;
use Illuminate\Testing\TestResponse;
use Tests\TestCase;

class AccountShowTest extends TestCase
{
    use RefreshDatabase;

    protected User $user;

    public function setUp(): void
    {
        parent::setUp();

        $this->user = User::factory()->create();
    }

    protected function getProfile(): TestResponse
    {
        return $this->actingAs($this->user)
            ->getJson(route('account.show'));
    }

    public function testUserFound(): void
    {
        $response = $this->getProfile();

        $response->assertJson([
            'data' => [
                'id' => $this->user->id,
                'first_name' => $this->user->first_name,
                'last_name' => $this->user->last_name,
                'email' => $this->user->email,
                'email_verified_at' => $this->user->email_verified_at->toJson(),
                'role' => $this->user->role,
            ],
        ]);
    }
}
