<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('item_records', function (Blueprint $table) {
            $table->id();
            $table->foreignId('driver_item_id')->constrained()->cascadeOnDelete();
            $table->timestamp('date');
            $table->float('max')->nullable();
            $table->float('min')->nullable();
            $table->text('comments')->nullable();
            $table->string('type')->default('normal');
            $table->json('attachments')->nullable();
            $table->timestamps();
        });
    }

    public function down(): void
    {
        Schema::table('item_records', function (Blueprint $table) {
            $table->dropForeign(['driver_item_id']);
        });

        Schema::dropIfExists('item_records');
    }
};
