<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('driver_items', function (Blueprint $table) {
            $table->id();
            $table->foreignId('key_driver_id')->constrained()->cascadeOnDelete();
            $table->string('name');
            $table->float('max')->nullable();
            $table->float('min')->nullable();
            $table->boolean('range');
            $table->timestamps();
        });
    }

    public function down(): void
    {
        Schema::table('key_drivers', function (Blueprint $table) {
            $table->dropForeign(['key_driver_id']);
        });

        Schema::dropIfExists('driver_items');
    }
};
