<?php

namespace Database\Factories;

use App\Models\DriverItem;
use Illuminate\Database\Eloquent\Factories\Factory;
use Illuminate\Support\Arr;

class ItemRecordFactory extends Factory
{
    public function definition(): array
    {
        return [
            'driver_item_id' => DriverItem::factory(),
            'date' => now()->startOfDay(),
            'max' => fake()->numberBetween(21, 40),
            'min' => fake()->numberBetween(0, 21),
            'comments' => fake()->paragraph(),
            'type' => Arr::random(['normal', 'decision', 'risk', 'constraint', 'test']),
            'attachments' => $this->getAttachments(),
        ];
    }

    public function getAttachments(): array
    {
        $attachments = [];

        for ($i = 0; $i < 3; $i++) {
            $attachmets[$i] = 'https://picsum.photos/id/'.rand(0, 1084).'/200/200';
        }

        return $attachments;
    }
}
