<?php

namespace App\Notifications;

use App\Models\Project;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Notifications\Messages\MailMessage;
use Illuminate\Notifications\Notification;

class ProjectUserRemoved extends Notification implements ShouldQueue
{
    use Queueable;

    public function __construct(protected Project $project)
    {
    }

    public function via(object $notifiable): array
    {
        return ['mail'];
    }

    public function toMail(object $notifiable): MailMessage
    {
        return (new MailMessage)
            ->subject('Project Unsubscribed')
            ->greeting('Hi '.$notifiable->first_name.'!')
            ->line('You were removed as a collaborator for the project "'.$this->project->name.'".')
            ->line('Thank you for using our application!');
    }
}
