<?php

namespace App\Models;

use Exception;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Support\Carbon;

class ItemRecord extends Model
{
    use HasFactory;

    protected $fillable = [
        'driver_item_id',
        'date',
        'max',
        'min',
        'comments',
        'type',
        'attachments',
    ];

    protected $casts = [
        'date' => 'datetime:Y-m-d',
        'attachments' => 'array',
    ];

    public function item(): BelongsTo
    {
        return $this->belongsTo(DriverItem::class);
    }

    public function scopeWhereDateBetween(Builder $query, array $dates): void
    {
        try {
            $fromDate = Carbon::createFromFormat('Y-m-d', $dates['from'])->toDateString();
            $query->whereDate('date', '>=', $fromDate);
        } catch (Exception $e) {
        }

        try {
            $toDate = Carbon::createFromFormat('Y-m-d', $dates['to'])->toDateString();
            $query->whereDate('date', '<=', $toDate);
        } catch (Exception $e) {
        }
    }
}
