<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\HasMany;

class DriverItem extends Model
{
    use HasFactory;

    protected $fillable = [
        'key_driver_id',
        'name',
        'max',
        'min',
        'range',
    ];

    public function driver(): BelongsTo
    {
        return $this->belongsTo(KeyDriver::class);
    }

    public function records(): HasMany
    {
        return $this->hasMany(ItemRecord::class);
    }
}
