<?php

namespace App\Http\Resources;

use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class DriverItemResource extends JsonResource
{
    public function toArray(Request $request): array
    {
        return [
            'id' => $this->id,
            'key_driver_id' => $this->key_driver_id,
            'name' => $this->name,
            'max' => $this->max,
            'min' => $this->min,
            'range' => $this->range,
            'records' => ItemRecordResource::collection($this->whenLoaded('records')),
        ];
    }
}
