<?php

namespace App\Http\Requests;

use App\Models\KeyDriver;
use Illuminate\Database\Query\Builder;
use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Validation\Rule;

class KeyDriverStore extends FormRequest
{
    public function authorize(): bool
    {
        $user = $this->project->users()->find($this->user()->id);

        return $user->hasVerifiedEmail() && ($user->pivot->role === 'owner' || $user->pivot->role === 'admin');
    }

    public function rules(): array
    {
        return [
            'name' => [
                'required',
                'string',
                'max:255',
                Rule::unique('key_drivers')->where(function (Builder $query) {
                    $query->where('project_id', $this->project->id);
                }),
            ],
        ];
    }

    public function storeDriver(): KeyDriver
    {
        $driver = $this->project->drivers()->create($this->validated());

        return $driver;
    }
}
