<?php

namespace App\Http\Requests;

use Illuminate\Database\Query\Builder;
use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Validation\Rule;

class ItemRecordUpdate extends FormRequest
{
    public function authorize(): bool
    {
        $user = $this->project->users()->find($this->user()->id);

        return $user->hasVerifiedEmail() && ($user->pivot->role === 'owner' || $user->pivot->role === 'admin');
    }

    public function rules(): array
    {
        return [
            'date' => [
                'required',
                'date_format:Y-m-d',
                Rule::unique('item_records')->where(function (Builder $query) {
                    $query->where('driver_item_id', $this->item->id)
                        ->where('id', '<>', $this->record->id);
                }),
            ],
            'max' => ['required', 'numeric'],
            'min' => [
                $this->item->range ? 'required' : 'nullable',
                'numeric',
                'lt:max',
            ],
            'type' => [
                'required',
                Rule::in(['normal', 'decision', 'risk', 'constraint', 'test']),
            ],
            'comments' => ['nullable', 'string', 'max:1000'],
            'attachments' => ['array'],
            'attachments.*' => ['string'],
        ];
    }

    public function updateRecord(): void
    {
        $this->record->update($this->validated());
    }
}
