<?php

namespace App\Http\Requests;

use App\Models\DriverItem;
use Illuminate\Database\Query\Builder;
use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Validation\Rule;

class DriverItemStore extends FormRequest
{
    public function authorize(): bool
    {
        $user = $this->project->users()->find($this->user()->id);

        return $user->hasVerifiedEmail() && ($user->pivot->role === 'owner' || $user->pivot->role === 'admin');
    }

    public function rules(): array
    {
        return [
            'name' => [
                'required',
                'string',
                'max:255',
                Rule::unique('driver_items')->where(function (Builder $query) {
                    $query->where('key_driver_id', $this->driver->id);
                }),
            ],
            'range' => ['required', 'boolean'],
            'max' => ['nullable', 'numeric'],
            'min' => ['nullable', 'numeric', 'lt:max'],
        ];
    }

    public function storeItem(): DriverItem
    {
        $item = $this->driver->items()->create($this->validated());

        return $item;
    }
}
