<?php

namespace App\Http\Requests;

use App\Models\User;
use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Validation\Rule;

class AccountUpdate extends FormRequest
{
    public function authorize(): bool
    {
        return true;
    }

    public function rules(): array
    {
        return [
            'first_name' => ['required', 'string', 'max:255'],
            'last_name' => ['required', 'string', 'max:255'],
            'email' => ['required', 'string', 'email', 'max:255', Rule::unique('users')->ignore($this->user()->id)],
        ];
    }

    public function updateUser(): User
    {
        $user = $this->user();

        $data = $this->validated();

        if ($user->email !== $this->input('email')) {
            $data['email_verified_at'] = null;
        }

        $user->update($data);

        if (is_null($user->email_verified_at)) {
            $user->sendEmailVerificationNotification();
        }

        return $user;
    }
}
