<?php

namespace App\Http\Controllers;

use App\Http\Requests\PasswordForgot;
use App\Http\Requests\PasswordReset;
use App\Http\Resources\UserResource;
use Illuminate\Http\JsonResponse;

class PasswordController extends Controller
{
    public function __construct()
    {
        $this->middleware('guest');
    }

    public function forgot(PasswordForgot $request): JsonResponse
    {
        $status = $request->sendResetLink();

        return response()->json(['message' => __($status)]);
    }

    public function reset(PasswordReset $request): UserResource
    {
        $status = $request->resetPassword();

        return (new UserResource($request->user()))
            ->additional(['message' => __($status)]);
    }
}
