<?php

namespace App\Http\Controllers;

use App\Http\Requests\ItemRecordStore;
use App\Http\Requests\ItemRecordUpdate;
use App\Http\Resources\ItemRecordResource;
use App\Models\DriverItem;
use App\Models\ItemRecord;
use App\Models\KeyDriver;
use App\Models\Project;
use Illuminate\Http\Resources\Json\AnonymousResourceCollection;
use Illuminate\Support\Facades\Auth;

class ItemRecordController extends Controller
{
    public function __construct()
    {
        $this->middleware('auth');
    }

    public function index(Project $project, KeyDriver $driver, DriverItem $item): AnonymousResourceCollection
    {
        $records = $item->records()->orderBy('date', 'desc')->get();

        return ItemRecordResource::collection($records);
    }

    public function show(Project $project, KeyDriver $driver, DriverItem $item, ItemRecord $record): ItemRecordResource
    {
        return new ItemRecordResource($record);
    }

    public function store(Project $project, KeyDriver $driver, DriverItem $item, ItemRecordStore $request): ItemRecordResource
    {
        $record = $request->storeRecord();

        return (new ItemRecordResource($record))
            ->additional(['message' => 'The record was saved successfully.']);
    }

    public function update(Project $project, KeyDriver $driver, DriverItem $item, ItemRecord $record, ItemRecordUpdate $request): ItemRecordResource
    {
        $request->updateRecord();

        return (new ItemRecordResource($record))
            ->additional(['message' => 'The record was updated successfully.']);
    }

    public function delete(Project $project, KeyDriver $driver, DriverItem $item, ItemRecord $record): ItemRecordResource
    {
        $user = $project->users()->find(Auth::id());

        abort_if(
            ! $user->hasVerifiedEmail() ||
            $user->pivot->role === 'user',
            403,
            'This action is unauthorized.'
        );

        $record->delete();

        return (new ItemRecordResource($record))
            ->additional(['message' => 'The record was deleted successfully.']);
    }
}
