<?php

namespace App\Http\Controllers;

use App\Http\Requests\EmailVerify;
use Illuminate\Http\JsonResponse;
use Illuminate\Http\Request;

class EmailVerificationController extends Controller
{
    public function __construct()
    {
        $this->middleware(['auth', 'throttle:6,1']);

        $this->middleware('signed')->only('verify');
    }

    public function verify(EmailVerify $request): JsonResponse
    {
        $message = $request->verifyEmail();

        return response()->json(['message' => $message]);
    }

    public function notify(Request $request)
    {
        if ($request->user()->hasVerifiedEmail()) {
            return response()->json(['message' => 'Your email is already verified.']);
        }

        $request->user()->sendEmailVerificationNotification();

        return response()->json(['message' => 'We send you an email with the verification link, please check your inbox.']);
    }
}
