<?php

namespace App\Http\Controllers;

use App\Http\Requests\DriverItemStore;
use App\Http\Requests\DriverItemUpdate;
use App\Http\Resources\DriverItemResource;
use App\Models\DriverItem;
use App\Models\KeyDriver;
use App\Models\Project;
use Illuminate\Http\Resources\Json\AnonymousResourceCollection;
use Illuminate\Support\Facades\Auth;

class DriverItemController extends Controller
{
    public function __construct()
    {
        $this->middleware('auth');
    }

    public function index(Project $project, KeyDriver $driver): AnonymousResourceCollection
    {
        $items = $driver->items()->get();

        return DriverItemResource::collection($items);
    }

    public function show(Project $project, KeyDriver $driver, DriverItem $item): DriverItemResource
    {
        return new DriverItemResource($item);
    }

    public function store(Project $project, KeyDriver $driver, DriverItemStore $request): DriverItemResource
    {
        $item = $request->storeItem();

        return (new DriverItemResource($item))
            ->additional(['message' => 'The driver item was saved successfully.']);
    }

    public function update(Project $project, KeyDriver $driver, DriverItem $item, DriverItemUpdate $request): DriverItemResource
    {
        $request->updateItem();

        return (new DriverItemResource($item))
            ->additional(['message' => 'The driver item was updated successfully.']);
    }

    public function delete(Project $project, KeyDriver $driver, DriverItem $item): DriverItemResource
    {
        $user = $project->users()->find(Auth::id());

        abort_if(
            ! $user->hasVerifiedEmail() ||
            $user->pivot->role === 'user',
            403,
            'This action is unauthorized.'
        );

        $item->delete();

        return (new DriverItemResource($item))
            ->additional(['message' => 'The driver item was updated successfully.']);
    }
}
