<?php

namespace App\Http\Controllers;

use App\Http\Requests\SignIn;
use App\Http\Requests\SignUp;
use App\Http\Resources\UserResource;
use Illuminate\Http\JsonResponse;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class AuthController extends Controller
{
    public function __construct()
    {
        $this->middleware('guest')->except('signOut');

        $this->middleware('auth')->only('signOut');
    }

    public function signIn(SignIn $request): UserResource
    {
        $request->authenticate();

        $request->session()->regenerate();

        return (new UserResource($request->user()))
            ->additional(['message' => 'Welcome back!']);
    }

    public function signUp(SignUp $request): UserResource
    {
        $user = $request->createUser();

        return (new UserResource($user))
            ->additional(['message' => 'Welcome to PSDM APP!']);
    }

    public function signOut(Request $request): JsonResponse
    {
        Auth::guard('web')->logout();

        $request->session()->invalidate();

        $request->session()->regenerateToken();

        return response()->json(['message' => 'See you back soon!']);
    }
}
