<?php

namespace App\Http\Controllers;

use App\Http\Requests\AccountPassword;
use App\Http\Requests\AccountUpdate;
use App\Http\Resources\UserResource;
use Illuminate\Support\Facades\Auth;

class AccountController extends Controller
{
    public function __construct()
    {
        $this->middleware('auth');
    }

    public function show(): UserResource
    {
        return new UserResource(Auth::user());
    }

    public function update(AccountUpdate $request): UserResource
    {
        $user = $request->updateUser();

        return (new UserResource($user))
            ->additional(['message' => 'Your information was updated successfully.']);
    }

    public function updatePassword(AccountPassword $request): UserResource
    {
        $user = $request->updatePassword();

        return (new UserResource($user))
            ->additional(['message' => 'Your new password was saved succesfully.']);
    }
}
