## Server Configuration Apache

First check Apache system service exists with the following command.

```
sudo systemctl status apache2
```

If there is no Apache service, you can install it with the following command.

```
sudo apt install apache2
```

If you are using a firewall, it is necessary to establish a rule in the Firewall so that Apache can run smoothly with the following command. If you have no firewall installed, feel free to skip this step.

```
sudo ufw allow “Apache Full”
```

Now you can check the Apache service exists with the command mentioned above. Now if you open a browser and navigate to your server IP or domain name the Apache default page should load.

The entry file Laravel uses is `index.php` in the project `public` directory. In order to route the traffic a new virtual host has to be created. Usually the path where the file is created is `/etc/apache2/sites-available`, but it may change based on your settingd. Below there is an example of the virtual host config.

```
<VirtualHost *:80>

    ServerAdmin jestupinan@zeerbyte.com
    ServerName zeerbyte.com
    DocumentRoot /var/www/html/public

    <Directory /var/www/html/public>
       Options +FollowSymlinks
       AllowOverride All
       Require all granted
    </Directory>

    ErrorLog ${APACHE_LOG_DIR}/error.log
    CustomLog ${APACHE_LOG_DIR}/access.log combined

</VirtualHost>
```

After creating the virtual host file, disable the default configuration file of the virtual hosts in Apache and enable the new virtual host.

```
sudo a2dissite 000-default.conf
sudo a2ensite <LARAVEL_PROJECT>
```

Now the Apache rewrite module should be enabled., and finally restart the Apache service.

```
sudo a2enmod rewrite
sudo systemctl restart apache2
```

## PHP Setup

The web server should have the following minimum PHP version and extensions:

-   PHP >= 8.1
-   Ctype PHP Extension
-   cURL PHP Extension
-   DOM PHP Extension
-   Fileinfo PHP Extension
-   Filter PHP Extension
-   Hash PHP Extension
-   Mbstring PHP Extension
-   OpenSSL PHP Extension
-   PCRE PHP Extension
-   PDO PHP Extension
-   Session PHP Extension
-   Tokenizer PHP Extension
-   XML PHP Extension

PHP comes by default on Ubuntu official repositories. You will need to install the language itself with the modules mentioned above. To do this run the following command.

```
sudo apt install php libapache2-mod-php php-mbstring php-xmlrpc php-soap php-gd php-xml php-cli php-zip php-bcmath php-tokenizer php-json php-pear
```

If the following command produced an output saying some packages were not found, simply update your Ubuntu by running the following command, and rerun the previous one.

```
apt-get update
```

To test PHP is working correctly, you need to create a file in Apache’s root directory. Let’s call it test.php. Run the following command.

```
sudo nano /var/www/html/test.php
```

Now add the call to phpinfo function to this file.

```php
<?php
    phpinfo();
?>
```

To save the file press `CTRL+O` and exit with `CTRL+X`. Now open the browser and navigate to `http://<YOUR-IP-OR-DOMAIN>/test.php`. The phpinfo page should load, where you can confirm the modules mentioned above are enabled.

## Composer Setup

Composer is a PHP dependency manager that facilitates the download of PHP libraries in our projects. Fist download Composer.

```
curl -sS https://getcomposer.org/installer | php
```

You have to make sure Composer can be used globally and make it executable. The following commands will take care of that.

```
sudo mv composer.phar /usr/local/bin/composer
```

```
sudo chmod +x /usr/local/bin/composer
```

## PostgreSQL Setup

Ubuntu default repositories contain Postgres packages, so you can install these using the `apt` packaging system. So first update the OS with the following command.

```
sudo apt-get
```

Now install the Postgres package along with a -contrib package that adds some additional utilities and functionality.

```
sudo apt install postgresql postgresql-contrib
```

Ensure that the server is running using the systemctl start command

```
sudo systemctl start postgresql.service
```

By default, Postgres uses a concept called `roles` to handle authentication and authorization. These are, in some ways, similar to regular Unix-style accounts, but Postgres does not distinguish between users and groups and instead prefers the more flexible term `role`.

Upon installation, Postgres is set up to use peer authentication, meaning that it associates Postgres roles with a matching Unix/Linux system account. If a role exists within Postgres, a Unix/Linux username with the same name is able to sign in as that role.

The installation procedure created a user account called postgres that is associated with the default Postgres role. In order to use Postgres, you can log into that account.

There are a few ways to utilize this account to access Postgres. The easiest way is to switch over to the postgres account on your server by typing the following command.

```
sudo -i -u postgres
```

You can now access the PostgreSQL prompt immediately with the following command.

```
psql
```

Another assumption that the Postgres authentication system makes by default is that for any role used to log in, that role will have a database with the same name which it can access. You can create the appropriate database with the createdb command. If you are logged in as the postgres account, you would type something like the following command

```
createdb mydatabase
```

## Project Setup

The project does not track the `.env` file to avoid saving sensitive data, but it provides a `.env.example` file. The contents of the example file should copied into a `.env` file in the root directory. Some values need to be updated based on the implementation, like `APP_URL`, `FRONTEND_URL`, `SESSION_DOMAIN`, etc.

Laravel uses [composer](https://getcomposer.org/) to manage its dependencies, so it should be installed on the web server. Once composer is installed, the following command can be used to install the dependencies:

```
php composer install --no-dev --no-interaction --prefer-dist --optimize-autoloader
```

The command above install only the production dependencies for the project and optimize the autoloader for production environment.

Laravel uses an app key set in the `.env` file, which is empty by default. By running the following command a new key will be set in the `.env` file.

```
php artisan key:generate
```

Now the database migrations can be run in the project with the following command:

```
php artisan migrate --force
```

Finally the following commands should be run to optimize some configurations.

```
php artisan config:cache
php artisan event:cache
php artisan route:cache
php artisan view:cache
```

### NOTE

This project is currently running in a DigitalOcean droplet of 1GB Memory and 25GB Disk with Ubuntu 22.04 (LTS) x64. Also the server where is deployed also hosts the frontend.
