# Assessing Behavioral Changes through eHealth in Smoking Cessation
## Dataset overview

#### Author: Jonathan van Oudheusden

#### Date: January 2024
This file is meant to give you an overview of the python scripts used for calculating values and generating images. This folder also contains the coding used for thematic analysis.

### Study
This study was done with data collected in https://osf.io/nuy4w. However at the time of releasing this, the files used in the analysis won't be released. Eventually the data of the study will be made available at https://osf.io/nuy4w. Then the data file will have to be matched up with the original data using the PID and session_num.

This work is part of the multidisciplinary research project Perfect Fit, which is supported by several funders organized by the Netherlands Organization for Scientific Research (NWO), program Commit2Data - Big Data \& Health (project number 628.011.211). Besides NWO, the funders include the Netherlands Organisation for Health Research and Development (ZonMw), Hartstichting, the Ministry of Health, Welfare, and Sport (VWS), Health Holland, and the Netherlands eScience Center.

### Data
This dataset contains 3 kinds of data:
- Excel sheet with PID, session_num, ownCodes and PeerCodes
- Python code used for calculations
- images generated by the python code, used in the report

### Files
This folder contains the following files:
- combinedCodes.xlsx: Excel sheet that has the thematic codes and peer codes, with PID and session_num.
The thematic codes and peer codes, contains the codes created during thematic analysis. 
The PID is a unique identifiers to identity the data with the participant, and the session_num is in what session each response was.
- PreProcessingData.py: Script used for combining session data and post questionaire into single excel sheet.
- CombinePeerCoding.py: Python code used to combine personal codes with peer codes. Peer codes didn't have rand_id and session, therefore they had to be matched with the text entries, this is removed now, so you won't be able to match them together anymore now. 
- CalculateCodingAgreement.py: Python script used for calculating cohen agreement, and print out all the codes, their agreement and how often they are used, in both our own codes and the peercodes.
- CalcGenderParticipants.py: Python script used for calculating the man/women/non-binary ratio of the participants
- PieChartThemes.py: Python script used for generating pie chart of all themes.
- pieChart.png: pie chart generated by the previous python code
- DropoutEffortStateCalCohenD.py: Python code used for calculating the effect size cohen d of dropout, effort and the usefulness beliefs related to this work. It also calculates the average effort per persuasive activity
- plot.png: graph generated by the previous DropoutEffortStateCalCohenD.py.
- effort.png: average effort graph, generated by DropoutEffortStateCalCohenD.py
- themesParActivity.py: Python code used for generating which themes show up with which activities.
- themesPerActivity.png: generated by themesParActivity.py.
- requirements.txt: all pip requirements for running the python code
- Theme.md: All themes, the theme definitions and codes that fall under each theme
- README.md: This README-file.
- ChecklistDataRepositoryReview.docx: checklist for this repository





