# -*- coding: utf-8 -*-
"""
Created on Fri Dec 18 09:44:34 2020

@author: fvanriggelen
"""

#%%importing python packages 
import matplotlib.pyplot as plt
import numpy as np

plt.rcParams['image.cmap'] = 'gray_r'
plt.rcParams["figure.figsize"] = [2,3]
plt.rcParams.update({'font.size': 7})
plt.rcParams['font.family']='arial'

#%% defining a function that plots the image 
def pcolormesh_centre(x, y, im, xlabel, ylabel, vmin=None, vmax=None):
    """ Wrapper for pcolormesh to plot pixel centres at data points.
    """
    dx=np.diff(x)
    dy=np.diff(y)
    dx=np.hstack( (dx[0], dx, dx[-1]))
    dy=np.hstack( (dy[0], dy, dy[-1]))
    xx=np.hstack( (x, x[-1]+dx[-1]))-dx/2
    yy=np.hstack( (y, y[-1]+dy[-1]))-dy/2
    plt.figure()
    if (vmin is not None) and (vmax is not None):
        plt.pcolormesh(xx, yy, im, vmin=vmin, vmax= vmax)
    else:
        plt.pcolormesh(xx, yy, im)
    plt.xlabel(xlabel)
    plt.ylabel(ylabel)
    plt.tight_layout()
    
#%% importing the data
xx = np.loadtxt('Figure_4a_xx.txt')
yy = np.loadtxt('Figure_4a_yy.txt')
image = np.loadtxt('Figure_4a_image.txt')

#%% plotting the image
pcolormesh_centre(xx, yy, image, '$\delta$$V_{\epsilon1234}$ (mV)', '$\delta$$V_{U1234}$ (mV)')
v1 = np.linspace(0.15, 0.25, 5, endpoint=False)
plt.tight_layout()
