# -*- coding: utf-8 -*-
"""
Created on Thu Dec 17 17:36:36 2020

@author: fvanriggelen
"""


import numpy as np
import matplotlib.pyplot as plt

plt.rcParams["figure.figsize"] = [2.3,2.0]
plt.rcParams.update({'font.size': 7})
plt.rcParams['font.family']='arial'

#%%
B41value = np.loadtxt('Figure_3f.txt')[0]
tunnel_coupling = np.loadtxt('Figure_3f.txt')[1]
std = np.loadtxt('Figure_3f.txt')[2]

#%%
plt.figure()
plt.errorbar(B41value, tunnel_coupling, yerr = std, linestyle = '--', marker = 'o', markersize = 2, color ='C4')
plt.xlabel('Gate voltage $\delta$$V_{B34}$ (mV)')
plt.ylabel('Tunnel coupling (GHz)')
plt.tight_layout()

#%%
def model(V):
    c = 2.82e9
    b = 2.40975
    V0 = -17.6
    V1 = -25.2
    fitted_model = np.sqrt(abs(16*c*(V-V0)/((V-V1)**2)))*np.exp(-b*np.sqrt(abs(V-V0)))
    return fitted_model

V_range = np.arange(0,-10,-0.1)

#plt.figure()
plt.plot(V_range, model(V_range),'k')
