# -*- coding: utf-8 -*-
"""
Created on Thu Dec 17 16:18:44 2020

@author: fvanriggelen
"""

import matplotlib.pyplot as plt
import numpy as np
import scipy
from qtt.algorithms.tunneling import fit_pol_all, polmod_all_2slopes # explanation of these functions can be found on the github page of qtt

plt.rcParams["figure.figsize"] = [2.3,2.0]
plt.rcParams.update({'font.size': 7})
plt.rcParams['font.family']='arial'

#%%
def plot_polarization_fit(detuning, signal, results, fig, verbose=1):
    """ Plot the results of a polarization line fit.

    Args:
        detuning (array): detuning in ueV.
        signal (array): measured signal.
        results (dict): results of fit_pol_all.
        fig (int or None): figure handle.
        verbose (int): Verbosity level.

    """
    h = scipy.constants.physical_constants['Planck constant in eV s'][0] * \
        1e15  # ueV/GHz; Planck's constant in eV/Hz*1e15 -> ueV/GHz

    par_fit = results['fitted_parameters']
    initial_parameters = results['initial_parameters']
    kT = results['kT']

    if fig is not None:
        plt.figure(fig)
        plt.clf()
        plt.plot(detuning/1000, signal, 'ko', markersize = 5)
        plt.plot(detuning/1000, polmod_all_2slopes(detuning, par_fit, kT), 'C4', linewidth=2)
        if verbose >= 2:
            plt.plot(detuning/1000, polmod_all_2slopes(detuning, initial_parameters, kT), ':c', label='initial guess')
        plt.xlabel('Detuning (meV)')
        _ = plt.ylabel('Charge sensor response (a.u.)')

#%%

detuning = np.loadtxt('Figure_3e.txt')[0]
signal = np.loadtxt('Figure_3e.txt')[1]

#%%
h = scipy.constants.physical_constants['Planck constant in eV s'][0]*1e15  # ueV/GHz; Planck's constant in eV/Hz*1e15 -> ueV/GHz
kb = scipy.constants.physical_constants['Boltzmann constant in eV/K'][0]*1e6  # ueV/K; Boltzmann constant in eV/K*1e6 -> ueV/K
kT = 400e-3 * kb  # effective electron temperature in eV
alpha = 0.19 #leverarm
conv_factor = 0.2417989 #convertion factor from micro eV to GHz

#%%
fitted_parameters, _, fit_results = fit_pol_all(detuning, signal, kT, method = 'curve_fit')
t_coupling = abs(fitted_parameters[0])*conv_factor
error = 0.2 #error of the fit
plot_polarization_fit(detuning, signal, fit_results, fig = 1)
plt.title('$t_{c}$ = %.1f $\pm$ %.1f (GHz)' % (t_coupling, error))
plt.tight_layout()