# -*- coding: utf-8 -*-
"""
Created on Thu Dec 17 13:40:02 2020

@author: fvanriggelen
"""

#%%importing python packages 
import matplotlib.pyplot as plt
import numpy as np

plt.rcParams["figure.figsize"] = [3,2.6]
plt.rcParams.update({'font.size': 8})
plt.rcParams['font.family']='arial'

#%% importing the data
data_dot1 = np.loadtxt('Figure_2b_dot1.txt')
data_dot2 = np.loadtxt('Figure_2b_dot2.txt')
data_dot3 = np.loadtxt('Figure_2b_dot3.txt')
data_dot4 = np.loadtxt('Figure_2b_dot4.txt')

#%%
fig, axs = plt.subplots(2, 2, sharex='col', sharey=True )
plt.subplots_adjust(top = 0.935, bottom = 0.175, left = 0.130, right = 0.96, hspace = 0.175, wspace = 0.2)
axs[1, 0].errorbar(np.arange(1,len(data_dot3[0])+1), data_dot3[0], yerr = data_dot3[1], fmt='--.')
axs[1, 0].text(8,6, '$Q_3$', va='center')
axs[1, 0].axvline(x=2, ls = '--', c = 'k', alpha = 0.4)
axs[1, 0].axvline(x=6, ls = '--', c = 'k', alpha = 0.4)
axs[1, 0].set_xlim([0,10.3])
axs[1, 0].set_xticks([0,2,4,6,8,10])

axs[0, 0].errorbar(np.arange(1,len(data_dot1[0])+1), data_dot1[0], yerr = data_dot1[1], fmt='--.', color='C1')
axs[0, 0].text(8,6, '$Q_1$', va='center')
axs[0, 0].axvline(x=2, ls = '--', c = 'k', alpha = 0.4)
axs[0, 0].axvline(x=6, ls = '--', c = 'k', alpha = 0.4)
axs[0, 0].set_xlim([0,10.3])
axs[0, 0].set_xticks([0,2,4,6,8,10])

axs[0, 1].errorbar(np.arange(1,len(data_dot2[0])+1), data_dot2[0], yerr = data_dot2[1], fmt='--.', color='C2')
axs[0, 1].text(8,6, '$Q_2$', va='center')
axs[0, 1].axvline(x=2, ls = '--', c = 'k', alpha = 0.4)
axs[0, 1].axvline(x=6, ls = '--', c = 'k', alpha = 0.4)
axs[0, 1].set_xlim([0,10.3])
axs[0, 1].set_xticks([0,2,4,6,8,10])

axs[1, 1].errorbar(np.arange(1,len(data_dot4[0])+1), data_dot4[0], yerr = data_dot4[1], fmt='--.', color='C3')
axs[1, 1].text(8,6, '$Q_4$', va='center')
axs[1, 1].axvline(x=2, ls = '--', c = 'k', alpha = 0.4)
axs[1, 1].axvline(x=6, ls = '--', c = 'k', alpha = 0.4)
axs[1, 1].set_xlim([0,10.3])
axs[1, 1].set_xticks([0,2,4,6,8,10])

fig.text(0.4, 0.06,'Hole occupation N', va='center')
fig.text(0.016, 0.5, 'Addition energy (meV)', va='center', rotation='vertical')


