require(reshape2)
require(foreach)
require(plyr)
require(lubridate)
require(MASS)
require(base)
require(polynom)
require(gridExtra)
require(ggplot2)
require(stringr)
library(scales)

source("./R Scripts/FunctionsFI.R")
#Load files 
Para <- read.table(file   = "./Data/Coefficents.txt", 
                   header = TRUE)
Dens <- read.csv  (file   = "./R Data/Density.csv", 
                   header = TRUE)
Temp <- read.csv  (file   = "./R Data/Temp.csv",
                   header=TRUE)
Names    <- read.csv  (file = "./R Data/Names.csv",        header = TRUE)

Dens$Help<-ifelse(Dens$Station %in% NA,1,2)
Dens<-Dens[!is.na(Dens$Length),]
Dens$datum<-ymd(Dens$datum)
#get ridd of LK and Length
AvgLStat<-ddply(Dens,c("Cruiseid","datum","Station","NumStat", "Species","Age","Help"),
                summarize,TLN=sum(LN),TNumStat=sum(TNum),TNumStat1000m=sum(TNum1000m))
AvgLStat$AvgLStat<-AvgLStat$TLN/AvgLStat$TNumStat
AvgLCrus<-ddply(AvgLStat,c("Cruiseid","datum","NumStat","Species","Age","Help"),
                summarize,TLN=sum(TLN),TNumCrus=sum(TNumStat),
                TNumCrus1000m=sum(TNumStat1000m))
AvgLCrus$AvgLCrus<-AvgLCrus$TLN/AvgLCrus$TNumCrus

AvgLCrus3<-merge(AvgLCrus,Para,by="Species")
AvgLCrus3$NumStat<-ifelse(AvgLCrus3$Species!=154 & AvgLCrus3$Cruiseid==201404,
                          18,AvgLCrus3$NumStat)

AvgLCrus3$AvgNumCrus1000m<-ifelse(AvgLCrus3$Help==1,AvgLCrus3$TNumCrus1000m,
                                  AvgLCrus3$TNumCrus1000m/AvgLCrus3$NumStat)
AvgLCrus3<-AvgLCrus3[!is.na(AvgLCrus3$TNumCrus),]
AvgLCrus3<-AvgLCrus3[!is.na(AvgLCrus3$TNumCrus1000m),]
AvgLCrus3<-AvgLCrus3[!is.na(AvgLCrus3$AvgLCrus),]
AvgLCrus3$Year<-year(AvgLCrus3$datum)
AvgLCrusH<-merge(AvgLCrus3,Temp,by="Cruiseid")

Plaice0<-subset(AvgLCrus3,Species==154&Age==0,select=c("Cruiseid","Species",
                                                       "Age","datum","AvgNumCrus1000m"))
write.csv(Plaice0,file="./R Data/Dens-Plaice-0-group-All2.csv",row.names = FALSE)


AvgLCrus3<-ddply(AvgLCrusH,c("Year","Species","Age"),mutate,
                 Max=yday(datum)[AvgNumCrus1000m==max(AvgNumCrus1000m)],
                 GLall=G.a*exp(G.b*AvgLCrus),
                 GL=ifelse(yday(datum)<Max,
                           GLall[yday(datum)==Max], G.a*exp(G.b*AvgLCrus)))
G<-AvgLCrus3[,c("Species", "Cruiseid", "Age","GL")]
write.csv(G,file="./R Data/Growth.csv",row.names=FALSE)

Growth<-subset(AvgLCrus3,select=c(Species,Cruiseid,datum,Age,AvgLCrus,     
                                  TNumCrus1000m,Temp,G.a,G.b,Q10,          
                                  WW.AFDM,MaintC,AssiEff,a,b,            
                                  ref))
Growth$Day<-yday(Growth$datum)
Growth$AFDM<-Growth$WW.AFDM*(ifelse(Growth$ref==1,((Growth$AvgLCrus/10)*Growth$a)^Growth$b,
                                    Growth$a*((Growth$AvgLCrus/10)^Growth$b)))
Growth$Year<-year(Growth$datum)
Growth<-Growth[order(Growth$Species,Growth$Age,Growth$Year,Growth$datum),]

Corr<-ddply(Growth,.(Species,Age),summarize,CorLenDay=cor(AvgLCrus,Day),
            CorLenTemp=cor(AvgLCrus,Temp))


GrAll<-ddply(Growth,.(Year),GrowthYear)

ggplot(GrAll,aes(x=gL,y=gW))+
  labs(x="Growth in Length",y="Growth in Weight")+
  geom_point()+
  facet_wrap(~Species+Age)
ggsave("./Plots/growthweight-length.png")

Growth2<-GEst(GrAll)
Growth3<-subset(Growth2,Type=="D")
CoeffG<-ddply(subset(Growth2,Year%in%"Full"&r2%ni%NA),
              .(Species,r2,pa,pb),summarize,n=length(Species))

Growth4<-Growth3[,c("Species", "Cruiseid", "Age","PredGW")]
write.csv(Growth4,file="./R Data/GrowthN.csv",row.names=FALSE)
write.csv(Growth2,file="./R Data/GrowthPlot.csv",row.names=FALSE)
write.csv(CoeffG, file="./R Data/CoeffG.csv",row.names=FALSE)


###Use Plaice growth for all species
GrPlaice<-GEst(subset(GrAll,Species==154))
GrPlaice$GW2<-ifelse(GrPlaice$gW2<0,GrPlaice$gW2,GrPlaice$GW)
G.a<-unique(GrPlaice$G.a[GrPlaice$Age=="All"])
G.b<-unique(GrPlaice$G.b[GrPlaice$Age=="All"])
GrPlaice$Age<-as.factor(GrPlaice$Age)
GrPlaice$Age<-revalue(GrPlaice$Age, c("0"="0-group", "1"="I-group","2"="II-group","All"="All"))
colG<-c("All ages"="#999999" ,"0-group"="#3366CC","I-group"="#FF0000","II-group"="#000000")

GrowthPlaice1<-ggplot()+
  ylim(-0.1,0.15)+
  labs(x="Average Length [mm]",y=expression(paste('G[ ',d^-1,' ]')))+
  geom_point(data=subset(GrPlaice,Type=="D"&Age%ni%"All"),aes(x=AvgLCrus,y=GW,color=Age),size=1)
GrowthPlaice2<-GrowthPlaice1+
  geom_line(data=subset(GrPlaice,Type=="P" &
                          Age %in% c("All")&Year %in% "Full"),
            aes(x=AvgLCrus,y=PredGW,group=Age))+
  scale_color_manual(values=colG)
plot(GrowthPlaice2)




Growth5<-merge(Growth2,Names,by="Species")
Growth5$PredGW<-ifelse(Growth5$Species %in% c(155,158),exp(log(G.a)+(Growth5$AvgLCrus*G.b)),Growth5$PredGW)
write.csv(Growth5,file="./R Data/GrowthPlot2.csv",row.names=FALSE)
Growth6<-subset(Growth5,Type=="D")
Growth7<-Growth6[,c("Species", "Cruiseid", "Age","PredGW")]
Growth7$Age<-factor(Growth7$Age)
Growth5$Age<-revalue(Growth5$Age, c("0"="0-group", "1"="I-group","2"="II-group","All"="All"))

GrowthAll<-ggplot()+
  ylim(0,0.15)+
  labs(x="Average Length [mm]",y=expression(paste('G[ ',d^-1,' ]')))+
  geom_point(data=subset(Growth5,Type=="D"&Age%ni%"All"),aes(x=AvgLCrus,y=GW,color=Age),size=1)+
  geom_line(data=subset(Growth5,Type=="P"&Age %in% c("All")&Year %in% "Full"),
            aes(x=AvgLCrus,y=PredGW,group=Age))+
  scale_color_manual(values=colG)+
  facet_wrap(~LatName,scales="free_x",ncol=2)
plot(GrowthAll)

ggsave("./Plots/GrowthAll.pdf")

write.csv(Growth7,file="./R Data/GrowthN2.csv",row.names=FALSE)


#plot of the individual growth curves per AvgLCrus
Plot1<-ggplot()+
  ylim(0,0.1)+
  xlim(0,400)+
  geom_point(data=subset(Growth2,Type=="D"&Species %in% c(154,155,158)),aes(x=AvgLCrus,y=GW))
Plot2<-Plot1+
  geom_line(data=subset(Growth2,Type=="P" & Age %in% c("0","All")&Species %in% c(154,155,158)),
            aes(x=AvgLCrus,y=PredGW))+
  theme_bw()+
  #scale_colour_gradient(low="red")+
  facet_wrap(~Species+Age+Year)
plot(Plot2)




