# -*- coding: utf-8 -*-
"""
Created on Fri May  1 19:43:10 2020

@author: abombelli
"""

import numpy as np
import pandas as pd
import os
import openpyxl
import datetime
import matplotlib.pyplot as plt
import matplotlib.dates as mdates
from matplotlib.dates import DateFormatter
from matplotlib.lines import Line2D
from collections import Counter

# Path to current folder
cwd = os.getcwd()

# Close all Figures
plt.close('all')

# All Markers (for plotting purposes) 
all_markers = list(Line2D.markers.keys())
# Define a list of colors
def hex2rgb(c):
    "Function to convert color codes from HEX to RGB"
    return tuple(int(c[i:i+2], 16)/256.0 for i in (1, 3 ,5))

colors = ['#CD6839','#4169E1','#2E8B57','#FFA500','#CD5C5C','#4682B4','#228B22','#191970','#1E90FF',
          '#8B8386','#00008B','#6C7B8B','#008B8B','#FFB90F','#CD853F','#CD3333','#CD0000','#6E6E6E',
          '#BF3EFF','#8B5A2B','#CDBA96','#008B45','#2E8B57','#104E8B','#009ACD','#B03060','#2E8B57',
          '#32CD32','#483D8B','#8B4513','#FF0000','#8B7765','#8B8970','#8B8878','#53868B','#CD9B1D']
colors = [hex2rgb(colors[i]) for i in range(len(colors))]

#############
### FedEx ###
#############

# Retrieve FedEx airports
df_FedEx_airports = pd.read_excel(os.path.join(cwd,'FedEx','FedEx_Airports.xlsx'),header=None,names=['idx','IATA_code','orig_idx'])

# Loading full freighter data
wb          = openpyxl.load_workbook(os.path.join(cwd,'FedEx','FedEx_aircraft.xlsx'))
sheet       = wb['Sheet1']
eta         = sheet.max_row
freighterCode      = []
freighterMaxTonnes = []

for row in range(2, eta+1):
    thisfreighterCode      = sheet['A' + str(row)].value
    thisfreighterMaxTonnes = sheet['B' + str(row)].value
    freighterCode.append(thisfreighterCode)
    freighterMaxTonnes.append(float(thisfreighterMaxTonnes))
    
full_list           = os.listdir(os.path.join(cwd,'FedEx','FedEx_Network'))
included_extensions = ['xlsx']

all_data = {}

axis_font      = {'fontname':'Arial', 'size':'9'}
colorbar_font  = {'fontname':'Arial', 'size':'14'}


# IATA codes of some major airports
US_labels = ['ANC','CDG','EWR','HKG','KIX','LAX','MEM','MIA','NRT','OAK'] 
    
for i in range(0,len(US_labels)):
    origin_airport = US_labels[i]
    for j in range(0,len(US_labels)):
        destination_airport = US_labels[j]
        
        if j != i:
        
            instances           = [fn for fn in full_list
                               if (any(fn.endswith(ext) for ext in included_extensions) 
                               and (origin_airport+'_' in fn and
                                    '_'+destination_airport in fn))]
            
            # If there are instances, store all dates and capacities
            if len(instances)>0:
                period_capacity = []
                for instance in instances:
                    location_ = [pos for pos, char in enumerate(instance) if char == '_']
                    month     = instance[location_[1]+1:location_[2]]
                    day       = instance[location_[2]+1:location_[3]]
                    year     =  instance[location_[3]+1:location_[4]]
                    d = datetime.datetime.strptime(day+' '+month+' '+year, '%d %B %Y').strftime('%d-%B-%Y')
                    wb = openpyxl.load_workbook(os.path.join(cwd,'FedEx','FedEx_Network',instance))
                    sheet       = wb['Sheet_name_1']
                    eta         = sheet.max_row
                    this_capacity= 0
                    
                    all_ac_types = []
                    # Determine most common aircraft type for this instance
                    for row in range(2, eta+1):
                        all_ac_types.append(sheet['C' + str(row)].value)
                    c = Counter(all_ac_types)
                    most_common_ac = c.most_common(1)[0][0]
                    if most_common_ac == 'N/A':
                        avgMaxTonnes = np.mean(freighterMaxTonnes)
                    else:
                        if len(np.where(np.array(freighterCode) == most_common_ac)[0])>0:
                            avgMaxTonnes = freighterMaxTonnes[np.where(np.array(freighterCode) == most_common_ac)[0][0]]
                    
                    
                    
                    for row in range(2, eta+1):
                        thisAircraftType = sheet['C' + str(row)].value
                        
                        if thisAircraftType in freighterCode:
                            idxAircraft          = np.where(np.array(freighterCode) == thisAircraftType)[0][0]
                            this_capacity += freighterMaxTonnes[idxAircraft]
                        else:
                            if thisAircraftType == 'N/A':
                                this_capacity += avgMaxTonnes
                            
                    period_capacity.append([d,this_capacity])
                    
                all_data[origin_airport+'_'+destination_airport] = period_capacity

# All O-D pair strings
vocab = list(all_data.keys())

# Get all unique dates of the observations
all_dates = []
for i in range(0,int(len(vocab))):
    this_block = all_data[vocab[i]]
    for j in range(0,int(len(this_block))):
        if this_block[j][0] not in all_dates:
            all_dates.append(this_block[j][0])
    
df_dates = pd.DataFrame(np.array(all_dates),columns=['Date'])
df_dates['Date'] =pd.to_datetime(df_dates.Date)
df_dates_sorted = df_dates.sort_values(by='Date')
df_dates_sorted = df_dates_sorted.reset_index(drop=True)

# Find which observations were split over 2 days (we assume observations
# were split at most over 2 days) so that we know with precision how
# many observations we have and can look for day or day+1 in case of a 
# split observation
delta_days = []
for i in range(0,int(len(df_dates_sorted)-1)):
    delta_days.append((df_dates_sorted['Date'][i+1]-df_dates_sorted['Date'][i]).days)
    
consecutive_days_idx = np.where(np.array(delta_days)==1)[0]+1

observation_dates = []
cont              = 0
while cont < int(len(df_dates_sorted)):
    if cont not in consecutive_days_idx and cont+1 not in consecutive_days_idx:
        observation_dates.append([df_dates_sorted['Date'][cont].strftime('%d-%B-%Y')])
        cont += 1
    elif cont not in consecutive_days_idx and cont+1 in consecutive_days_idx:
        observation_dates.append([df_dates_sorted['Date'][cont].strftime('%d-%B-%Y'),df_dates_sorted['Date'][cont+1].strftime('%d-%B-%Y')])
        cont += 2

idx_observations_to_consider = np.arange(0,len(observation_dates)).tolist()
AFT_matrix                   = []
# Generating a matrix plot for every observation we want to show
for idx_obs in idx_observations_to_consider:
    dates_to_check = observation_dates[idx_obs]
    this_matrix = np.zeros([len(US_labels),len(US_labels)])
    for i in range(0,len(US_labels)):
        origin_airport = US_labels[i]
        for j in range(0,len(US_labels)):
            
            if j != i:
            
                destination_airport = US_labels[j]
                if origin_airport+'_'+destination_airport not in vocab:
                    this_matrix[i][j] = 0
                else:
                    exit_cond = False
                    not_found = False
                    cont      = 0
                    while exit_cond is not True:
                        if all_data[origin_airport+'_'+destination_airport][cont][0] in dates_to_check:
                            exit_cond = True
                        else:
                            cont += 1
                            if cont == len(all_data[origin_airport+'_'+destination_airport]):
                                not_found = True
                                break
                    if not_found is False:
                        this_matrix[i][j] = all_data[origin_airport+'_'+destination_airport][cont][1]
                    else:
                        this_matrix[i][j] = 0
                    
    AFT_matrix.append(this_matrix)

# Note: we have 10 observations, hence using a 2*5 format is good. In case
# the dataset is enriched with more observations, this format must be
# changed accordingly
columns = 5
rows    = 2
fig = plt.figure(figsize=(10, 8))
for i in range(1, columns*rows +1):                  
    xlabels_positions = np.linspace(0,len(US_labels)-1,len(US_labels))
    ylabels_positions = np.arange(len(US_labels))
    fig.add_subplot(rows, columns, i)        
    plt.imshow(AFT_matrix[i-1],cmap='coolwarm',aspect='auto',vmin=0,vmax=np.max(AFT_matrix))
    ax = plt.gca()
    ax.set_xticks(np.arange(len(US_labels)))
    ax.set_xticks(np.arange(len(US_labels))-.5,minor=True)
    ax.xaxis.set_ticks_position('none')
    ax.set_xticklabels(US_labels, rotation=90,**axis_font)
    ax.set_yticks(np.arange(len(US_labels)))
    ax.set_yticks(np.arange(len(US_labels))-.5,minor=True)
    ax.set_title(observation_dates[i-1][0],**axis_font)
    ax.yaxis.set_ticks_position('none')
    ax.set_yticklabels(US_labels, rotation=0,**axis_font)
    ax.grid( which = "minor", axis = 'x', color = "w", linestyle = '-', linewidth = .7 )
    ax.grid( which = "minor", axis = 'y', color = "w", linestyle = '-', linewidth = .7 )
cb_ax = fig.add_axes([1.05, 0.1, 0.02, 0.8])
# cbar = fig2.colorbar(im, cax=cb_ax)
cbar = plt.colorbar(cax=cb_ax)
cbar.set_label('AFT [tonnes]', rotation=90,**colorbar_font)
plt.tight_layout()
plt.show()
fig.savefig('FedEx_matrix.png', format='png', dpi=400, bbox_inches='tight',
              transparent=True,pad_inches=0.02)

# Now repeat the exact same process for UPS and DHL

###########
### UPS ###
###########
df_UPS_airports = pd.read_excel(os.path.join(cwd,'UPS','UPS_Airports.xlsx'),header=None,names=['idx','IATA_code','orig_idx'])

# Loading full freighter data
wb          = openpyxl.load_workbook(os.path.join(cwd,'UPS','UPS_aircraft.xlsx'))
sheet       = wb['Sheet1']
eta         = sheet.max_row
freighterCode      = []
freighterMaxTonnes = []

for row in range(2, eta+1):
    thisfreighterCode      = sheet['A' + str(row)].value
    thisfreighterMaxTonnes = sheet['B' + str(row)].value
    freighterCode.append(thisfreighterCode)
    freighterMaxTonnes.append(float(thisfreighterMaxTonnes))
    
full_list           = os.listdir(os.path.join(cwd,'UPS','UPS_Network'))
included_extensions = ['xlsx']

airports_to_consider = ['ANC','CGN','DFW','HKG','HNL','ONT','SDF','SZX']

all_data = {}

for i in range(0,len(airports_to_consider)):
    origin_airport = airports_to_consider[i]
    for j in range(0,len(airports_to_consider)):
        if i != j:
            destination_airport = airports_to_consider[j]
            instances           = [fn for fn in full_list
                               if any(fn.endswith(ext) for ext in included_extensions) 
                               and (origin_airport+'_' in fn and
                                    '_'+destination_airport in fn)]
            #print(instances)
            # If there are instances, store all dates and capacities
            if len(instances)>0:
                period_capacity = []
                for instance in instances:
                    location_ = [pos for pos, char in enumerate(instance) if char == '_']
                    month     = instance[location_[1]+1:location_[2]]
                    day       = instance[location_[2]+1:location_[3]]
                    year     =  instance[location_[3]+1:location_[4]]
                    d = datetime.datetime.strptime(day+' '+month+' '+year, '%d %B %Y').strftime('%d-%B-%Y')
                    wb = openpyxl.load_workbook(os.path.join(cwd,'UPS','UPS_Network',instance))
                    sheet       = wb['Sheet_name_1']
                    eta         = sheet.max_row
                    this_capacity= 0
                    
                    all_ac_types = []
                    # Determine most common aircraft type for this instance
                    for row in range(2, eta+1):
                        all_ac_types.append(sheet['C' + str(row)].value)
                    c = Counter(all_ac_types)
                    most_common_ac = c.most_common(1)[0][0]
                    if most_common_ac == 'N/A':
                        avgMaxTonnes = np.mean(freighterMaxTonnes)
                    else:
                        if len(np.where(np.array(freighterCode) == most_common_ac)[0])>0:
                            avgMaxTonnes = freighterMaxTonnes[np.where(np.array(freighterCode) == most_common_ac)[0][0]]
                    
                    
                    
                    for row in range(2, eta+1):
                        thisAircraftType = sheet['C' + str(row)].value
                        
                        if thisAircraftType in freighterCode:
                            idxAircraft          = np.where(np.array(freighterCode) == thisAircraftType)[0][0]
                            this_capacity += freighterMaxTonnes[idxAircraft]
                        else:
                            if thisAircraftType == 'N/A':
                                this_capacity += avgMaxTonnes
                            
                    period_capacity.append([d,this_capacity])
                    
                all_data[origin_airport+'_'+destination_airport] = period_capacity

all_data = {}


axis_font      = {'fontname':'Arial', 'size':'9'}
colorbar_font  = {'fontname':'Arial', 'size':'14'}

US_labels   = ['ANC','CGN','DFW','EWR','HKG','HNL','ICN','OAK','ONT','SDF']   
    
for i in range(0,len(US_labels)):
    origin_airport = US_labels[i]
    for j in range(0,len(US_labels)):
        destination_airport = US_labels[j]
        
        if j != i:
        
            instances           = [fn for fn in full_list
                               if (any(fn.endswith(ext) for ext in included_extensions) 
                               and (origin_airport+'_' in fn and
                                    '_'+destination_airport in fn))]
            
            # If there are instances, store all dates and capacities
            if len(instances)>0:
                period_capacity = []
                for instance in instances:
                    location_ = [pos for pos, char in enumerate(instance) if char == '_']
                    month     = instance[location_[1]+1:location_[2]]
                    day       = instance[location_[2]+1:location_[3]]
                    year     =  instance[location_[3]+1:location_[4]]
                    d = datetime.datetime.strptime(day+' '+month+' '+year, '%d %B %Y').strftime('%d-%B-%Y')
                    wb = openpyxl.load_workbook(os.path.join(cwd,'UPS','UPS_Network',instance))
                    sheet       = wb['Sheet_name_1']
                    eta         = sheet.max_row
                    this_capacity= 0
                    
                    all_ac_types = []
                    # Determine most common aircraft type for this instance
                    for row in range(2, eta+1):
                        all_ac_types.append(sheet['C' + str(row)].value)
                    c = Counter(all_ac_types)
                    most_common_ac = c.most_common(1)[0][0]
                    if most_common_ac == 'N/A':
                        avgMaxTonnes = np.mean(freighterMaxTonnes)
                    else:
                        if len(np.where(np.array(freighterCode) == most_common_ac)[0])>0:
                            avgMaxTonnes = freighterMaxTonnes[np.where(np.array(freighterCode) == most_common_ac)[0][0]]
                    
                    
                    
                    for row in range(2, eta+1):
                        thisAircraftType = sheet['C' + str(row)].value
                        
                        if thisAircraftType in freighterCode:
                            idxAircraft          = np.where(np.array(freighterCode) == thisAircraftType)[0][0]
                            this_capacity += freighterMaxTonnes[idxAircraft]
                        else:
                            if thisAircraftType == 'N/A':
                                this_capacity += avgMaxTonnes
                            
                    period_capacity.append([d,this_capacity])
                    
                all_data[origin_airport+'_'+destination_airport] = period_capacity

# ALl O-D pair strings
vocab = list(all_data.keys())

all_dates = []
for i in range(0,int(len(vocab))):
    this_block = all_data[vocab[i]]
    for j in range(0,int(len(this_block))):
        if this_block[j][0] not in all_dates:
            all_dates.append(this_block[j][0])
    
df_dates = pd.DataFrame(np.array(all_dates),columns=['Date'])
df_dates['Date'] =pd.to_datetime(df_dates.Date)
df_dates_sorted = df_dates.sort_values(by='Date')
df_dates_sorted = df_dates_sorted.reset_index(drop=True)

# Find which observations were split over 2 days (we assume observations
# were split at most over 2 days) so that we know with precision how
# many observations we have and can look for day or day+1 in case of a 
# split observation
delta_days = []
for i in range(0,int(len(df_dates_sorted)-1)):
    delta_days.append((df_dates_sorted['Date'][i+1]-df_dates_sorted['Date'][i]).days)
    
consecutive_days_idx = np.where(np.array(delta_days)==1)[0]+1

observation_dates = []
cont              = 0
while cont < int(len(df_dates_sorted)):
    if cont not in consecutive_days_idx and cont+1 not in consecutive_days_idx:
        observation_dates.append([df_dates_sorted['Date'][cont].strftime('%d-%B-%Y')])
        cont += 1
    elif cont not in consecutive_days_idx and cont+1 in consecutive_days_idx:
        observation_dates.append([df_dates_sorted['Date'][cont].strftime('%d-%B-%Y'),df_dates_sorted['Date'][cont+1].strftime('%d-%B-%Y')])
        cont += 2

idx_observations_to_consider = np.arange(0,len(observation_dates)).tolist()
AFT_matrix                   = []
# Generating a matrix plot for every observation we want to show
for idx_obs in idx_observations_to_consider:
    dates_to_check = observation_dates[idx_obs]
    this_matrix = np.zeros([len(US_labels),len(US_labels)])
    for i in range(0,len(US_labels)):
        origin_airport = US_labels[i]
        for j in range(0,len(US_labels)):
            
            if j != i:
            
                destination_airport = US_labels[j]
                if origin_airport+'_'+destination_airport not in vocab:
                    this_matrix[i][j] = 0
                else:
                    exit_cond = False
                    not_found = False
                    cont      = 0
                    while exit_cond is not True:
                        if all_data[origin_airport+'_'+destination_airport][cont][0] in dates_to_check:
                            exit_cond = True
                        else:
                            cont += 1
                            if cont == len(all_data[origin_airport+'_'+destination_airport]):
                                not_found = True
                                break
                    if not_found is False:
                        this_matrix[i][j] = all_data[origin_airport+'_'+destination_airport][cont][1]
                    else:
                        this_matrix[i][j] = 0
                    
    AFT_matrix.append(this_matrix)

columns = 5
rows    = 2
fig = plt.figure(figsize=(10, 8))
for i in range(1, columns*rows +1):                  
    xlabels_positions = np.linspace(0,len(US_labels)-1,len(US_labels))
    ylabels_positions = np.arange(len(US_labels))
    fig.add_subplot(rows, columns, i)        
    plt.imshow(AFT_matrix[i-1],cmap='Wistia',aspect='auto',vmin=0,vmax=np.max(AFT_matrix))
    ax = plt.gca()
    ax.set_xticks(np.arange(len(US_labels)))
    ax.set_xticks(np.arange(len(US_labels))-.5,minor=True)
    ax.xaxis.set_ticks_position('none')
    ax.set_xticklabels(US_labels, rotation=90,**axis_font)
    ax.set_yticks(np.arange(len(US_labels)))
    ax.set_yticks(np.arange(len(US_labels))-.5,minor=True)
    ax.set_title(observation_dates[i-1][0],**axis_font)
    ax.yaxis.set_ticks_position('none')
    ax.set_yticklabels(US_labels, rotation=0,**axis_font)
    ax.grid( which = "minor", axis = 'x', color = "w", linestyle = '-', linewidth = .7 )
    ax.grid( which = "minor", axis = 'y', color = "w", linestyle = '-', linewidth = .7 )
cb_ax = fig.add_axes([1.05, 0.1, 0.02, 0.8])
# cbar = fig2.colorbar(im, cax=cb_ax)
cbar = plt.colorbar(cax=cb_ax)
cbar.set_label('AFT [tonnes]', rotation=90,**colorbar_font)
plt.tight_layout()
plt.show()
fig.savefig('UPS_matrix.png', format='png', dpi=400, bbox_inches='tight',
              transparent=True,pad_inches=0.02)

###########
### DHL ###
###########
df_DHL_airports = pd.read_excel(os.path.join(cwd,'DHL','DHL_Airports.xlsx'),header=None,names=['idx','IATA_code','orig_idx'])

# Loading full freighter data
wb          = openpyxl.load_workbook(os.path.join(cwd,'DHL','DHL_aircraft.xlsx'))
sheet       = wb['Sheet1']
eta         = sheet.max_row
freighterCode      = []
freighterMaxTonnes = []

for row in range(2, eta+1):
    thisfreighterCode      = sheet['A' + str(row)].value
    thisfreighterMaxTonnes = sheet['B' + str(row)].value
    freighterCode.append(thisfreighterCode)
    freighterMaxTonnes.append(float(thisfreighterMaxTonnes))
    
full_list           = os.listdir(os.path.join(cwd,'DHL','DHL_Network'))
included_extensions = ['xlsx']

all_data = {}


axis_font      = {'fontname':'Arial', 'size':'9'}
colorbar_font  = {'fontname':'Arial', 'size':'14'}

US_labels   = ['ANC','CVG','DFW','EMA','HKG','ICN','LEJ','MIA','PVG']   
    
for i in range(0,len(US_labels)):
    origin_airport = US_labels[i]
    for j in range(0,len(US_labels)):
        destination_airport = US_labels[j]
        
        if j != i:
        
            instances           = [fn for fn in full_list
                               if (any(fn.endswith(ext) for ext in included_extensions) 
                               and (origin_airport+'_' in fn and
                                    '_'+destination_airport in fn))]
            
            # If there are instances, store all dates and capacities
            if len(instances)>0:
                period_capacity = []
                for instance in instances:
                    location_ = [pos for pos, char in enumerate(instance) if char == '_']
                    month     = instance[location_[1]+1:location_[2]]
                    day       = instance[location_[2]+1:location_[3]]
                    year     =  instance[location_[3]+1:location_[4]]
                    d = datetime.datetime.strptime(day+' '+month+' '+year, '%d %B %Y').strftime('%d-%B-%Y')
                    wb = openpyxl.load_workbook(os.path.join(cwd,'DHL','DHL_Network',instance))
                    sheet       = wb['Sheet_name_1']
                    eta         = sheet.max_row
                    this_capacity= 0
                    
                    all_ac_types = []
                    # Determine most common aircraft type for this instance
                    for row in range(2, eta+1):
                        all_ac_types.append(sheet['C' + str(row)].value)
                    c = Counter(all_ac_types)
                    most_common_ac = c.most_common(1)[0][0]
                    if most_common_ac == 'N/A':
                        avgMaxTonnes = np.mean(freighterMaxTonnes)
                    else:
                        if len(np.where(np.array(freighterCode) == most_common_ac)[0])>0:
                            avgMaxTonnes = freighterMaxTonnes[np.where(np.array(freighterCode) == most_common_ac)[0][0]]
                    
                    
                    
                    for row in range(2, eta+1):
                        thisAircraftType = sheet['C' + str(row)].value
                        
                        if thisAircraftType in freighterCode:
                            idxAircraft          = np.where(np.array(freighterCode) == thisAircraftType)[0][0]
                            this_capacity += freighterMaxTonnes[idxAircraft]
                        else:
                            if thisAircraftType == 'N/A':
                                this_capacity += avgMaxTonnes
                            
                    period_capacity.append([d,this_capacity])
                    
                all_data[origin_airport+'_'+destination_airport] = period_capacity

# ALl O-D pair strings
vocab = list(all_data.keys())

all_dates = []
for i in range(0,int(len(vocab))):
    this_block = all_data[vocab[i]]
    for j in range(0,int(len(this_block))):
        if this_block[j][0] not in all_dates:
            all_dates.append(this_block[j][0])
    
df_dates = pd.DataFrame(np.array(all_dates),columns=['Date'])
df_dates['Date'] =pd.to_datetime(df_dates.Date)
df_dates_sorted = df_dates.sort_values(by='Date')
df_dates_sorted = df_dates_sorted.reset_index(drop=True)

# Find which observations were split over 2 days (we assume observations
# were split at most over 2 days) so that we know with precision how
# many observations we have and can look for day or day+1 in case of a 
# split observation
delta_days = []
for i in range(0,int(len(df_dates_sorted)-1)):
    delta_days.append((df_dates_sorted['Date'][i+1]-df_dates_sorted['Date'][i]).days)
    
consecutive_days_idx = np.where(np.array(delta_days)==1)[0]+1

observation_dates = []
cont              = 0
while cont < int(len(df_dates_sorted)):
    if cont not in consecutive_days_idx and cont+1 not in consecutive_days_idx:
        observation_dates.append([df_dates_sorted['Date'][cont].strftime('%d-%B-%Y')])
        cont += 1
    elif cont not in consecutive_days_idx and cont+1 in consecutive_days_idx:
        observation_dates.append([df_dates_sorted['Date'][cont].strftime('%d-%B-%Y'),df_dates_sorted['Date'][cont+1].strftime('%d-%B-%Y')])
        cont += 2

idx_observations_to_consider = np.arange(0,len(observation_dates)).tolist()
AFT_matrix                   = []
# Generating a matrix plot for every observation we want to show
for idx_obs in idx_observations_to_consider:
    dates_to_check = observation_dates[idx_obs]
    this_matrix = np.zeros([len(US_labels),len(US_labels)])
    for i in range(0,len(US_labels)):
        origin_airport = US_labels[i]
        for j in range(0,len(US_labels)):
            
            if j != i:
            
                destination_airport = US_labels[j]
                if origin_airport+'_'+destination_airport not in vocab:
                    this_matrix[i][j] = 0
                else:
                    exit_cond = False
                    not_found = False
                    cont      = 0
                    while exit_cond is not True:
                        if all_data[origin_airport+'_'+destination_airport][cont][0] in dates_to_check:
                            exit_cond = True
                        else:
                            cont += 1
                            if cont == len(all_data[origin_airport+'_'+destination_airport]):
                                not_found = True
                                break
                    if not_found is False:
                        this_matrix[i][j] = all_data[origin_airport+'_'+destination_airport][cont][1]
                    else:
                        this_matrix[i][j] = 0
                    
    AFT_matrix.append(this_matrix)

columns = 5
rows    = 2
fig = plt.figure(figsize=(10, 8))
for i in range(1, columns*rows +1):                  
    xlabels_positions = np.linspace(0,len(US_labels)-1,len(US_labels))
    ylabels_positions = np.arange(len(US_labels))
    fig.add_subplot(rows, columns, i)        
    plt.imshow(AFT_matrix[i-1],cmap='Wistia',aspect='auto',vmin=0,vmax=np.max(AFT_matrix))
    ax = plt.gca()
    ax.set_xticks(np.arange(len(US_labels)))
    ax.set_xticks(np.arange(len(US_labels))-.5,minor=True)
    ax.xaxis.set_ticks_position('none')
    ax.set_xticklabels(US_labels, rotation=90,**axis_font)
    ax.set_yticks(np.arange(len(US_labels)))
    ax.set_yticks(np.arange(len(US_labels))-.5,minor=True)
    ax.set_title(observation_dates[i-1][0],**axis_font)
    ax.yaxis.set_ticks_position('none')
    ax.set_yticklabels(US_labels, rotation=0,**axis_font)
    ax.grid( which = "minor", axis = 'x', color = "w", linestyle = '-', linewidth = .7 )
    ax.grid( which = "minor", axis = 'y', color = "w", linestyle = '-', linewidth = .7 )
cb_ax = fig.add_axes([1.05, 0.1, 0.02, 0.8])
# cbar = fig2.colorbar(im, cax=cb_ax)
cbar = plt.colorbar(cax=cb_ax)
cbar.set_label('AFT [tonnes]', rotation=90,**colorbar_font)
plt.tight_layout()
plt.show()
fig.savefig('DHL_matrix.png', format='png', dpi=400, bbox_inches='tight',
              transparent=True,pad_inches=0.02)