function struct_out=analysis_run(struct_in,selection)

% check inputs
if nargin==0,
    disp('No inputs specified, do this first');
    return
end;

if nargin>1,
    %disp(sprintf('Running selected %s',num2str(selection)));
else
    selection=[1:size(struct_in,2)];
end;

num_actions=length(selection);
for a=1:num_actions

    action_script=struct_in{a}.type;

    if exist(action_script)==2,
        eval(sprintf('%s(struct_in{%0.0f});',action_script,a));
    else
        disp(sprintf('... ERROR: Unknown type of analysis: no. %s', struct_in{a}.type));
    end;        

end;

% Generate output
struct_out=struct_in;
    
disp('... Ready');

