% BScMarjoleinThijssen_analysis3

clear all

% load data
Experiment2_ExtractData
numSubjects=length(Subject);
cats={'A','B','C','D'};

% Overview of Qscale ratings
T=zeros(numSubjects,70);
L=zeros(numSubjects,70);
A=zeros(numSubjects,70);
NRS=zeros(numSubjects,70);
ROW1=zeros(numSubjects,70);
ROW2=zeros(numSubjects,70);
ROW3=zeros(numSubjects,70);
ROW4=zeros(numSubjects,70);
for s=1:numSubjects
    T(s,:)=Subject{s}.Exp_T';
    L(s,:)=Subject{s}.Exp_L';
    A(s,:)=Subject{s}.Exp_A';
    NRS(s,:)=Subject{s}.Exp_NRS';
    for r=1:4
        ROW{r}(s,:)=Subject{s}.Exp_ROW(:,r)';
    end;
end;

for r=1:4,
    fig{r} = figure(r);
    clf;
    
    ROWcnt_sum=zeros(7,5);

    for s=1:numSubjects
        subplot(2,numSubjects,s); hold on;

        for l=1:7
            loi=find(L(s,:)==l);
            if l<4
                lp='b.-';
            elseif l==4,
                lp='k.-';
            else
                lp='r.-';
            end;
            ROWlevel(l,:)=ROW{r}(s,loi);
            
            plot(T(s,loi),ROWlevel(l,:),lp);
            axis([0 71 0 5]);
            title(sprintf('Subject %d',s));
            xlabel('Trial');
            
            for c=1:5
                ROWcnt(l,c)=length(find(ROWlevel(l,:)==c));
            end;
            
        end;
        
        ROWcnt_sum=ROWcnt_sum+ROWcnt;
        if s==1, ylabel(sprintf('ROW %d',r)); end;
        
        subplot(2,numSubjects,numSubjects+s); hold on;
        %boxplot(ROW1level','colors','bbbkrrr');xlabel('Level');ylim([0 10]);
        bar(ROWcnt,'stacked');xlim([0.5 7.5]); xlabel('Level');
        
        if s==4,
            legend('Not applicable','Strength 1','Strength 2', 'Strength 3','Strength 4','Orientation','Horizontal','Location','southoutside');
            end;
      if s==1, ylabel(''); end;
    end;
    
    set(r,'Position',[51,342,1148,420]-r*10);
    close(fig{r});
    
    figure(5);
    subplot(1,4,r);bar(ROWcnt_sum,'stacked');xlim([0.5 7.5]); xlabel('Stimulus Intensity');
    title(cats{r});
        
end;
set(5,'Position',[51,342,1148,420]-r*10);
% legend({'NA','Lvl1','Lvl2','Lvl3','Lvl4'}, 'Location','northeastoutside', 'fontsize', 20, 'fontname', 'Corbel');
set(findobj(gcf, 'type', 'axes'), 'fontsize', 20, 'fontname', 'Corbel');
