clear all

% load data
Experiment2_ExtractData
numSubjects=length(Subject);
cats={'A','B','C','D'};

% Overview of Qscale ratings
T=zeros(numSubjects,70);
L=zeros(numSubjects,70);
A=zeros(numSubjects,70);
NRS=zeros(numSubjects,70);
ROW1=zeros(numSubjects,70);
ROW2=zeros(numSubjects,70);
ROW3=zeros(numSubjects,70);
ROW4=zeros(numSubjects,70);
for s=1:numSubjects
    T(s,:)=Subject{s}.Exp_T';
    L(s,:)=Subject{s}.Exp_L';
    A(s,:)=Subject{s}.Exp_A';
    NRS(s,:)=Subject{s}.Exp_NRS';
    ROW1(s,:)=Subject{s}.Exp_ROW(:,1)';
    ROW2(s,:)=Subject{s}.Exp_ROW(:,2)';
    ROW3(s,:)=Subject{s}.Exp_ROW(:,3)';
    ROW4(s,:)=Subject{s}.Exp_ROW(:,4)';
    for r=1:4
        ROW{r}(s,:)=Subject{s}.Exp_ROW(:,r)';
    end;
end;

figure(1);clf;
hold on; subplots = 0;
QSCats={'A','B','C','D'};
for r=1:4,

    ROWcnt_sum=zeros(7,5);
    pos=[6 8 10 12 15 17 19 21];

    for s=1:numSubjects
        subplots = subplots + 1;
        ps=pos(r)+((s-1)*22);
        sbplt{subplots} = subplot(numSubjects,22,ps:(ps+1)); hold on; 
        sbplt{subplots}.YGrid = 'on';
        set(gca,'YTick',[0 1 2 3 4]);

        if r==1
            set(gca,'YTick',[0 1 2 3 4] ,'YTickLabel',{'NA', '1', '2', '3', '4'}, 'fontsize', 15, 'fontname', 'Corbel');
        else
            set(gca,'YTickLabel',[]);    
        end
        
        if s==1
            title([QSCats{r}, '-I'], 'fontsize', 20, 'fontname', 'Corbel'); 
        end
            
        for l=1:7
            loi=find(L(s,:)==l);
            if l<4
                lp='b';
            elseif l==4,
                lp='k';
            else
                lp='r';
            end;
            ROWlevel(l,:)=ROW{r}(s,loi);
            
            scatter(T(s,loi),(ROWlevel(l,:)-1), 15, lp, 'filled');
            axis([0 71 0 4]);
            
            
            for c=1:5
                ROWcnt(l,c)=length(find(ROWlevel(l,:)==c));
            end; 
            
            if s==5 && r==1
                ylabel(['QScale Intensity'], 'fontsize', 35, 'fontname', 'Corbel')
            end
            
            if s==9
                set(gca,'XTick',[0 20 40 60] ,'XTickLabel',[0 20 40 60], 'fontsize', 15, 'fontname', 'Corbel');
            else
                set(gca,'XTickLabel',[]); 
            end
            
        end;
        
        ps=pos(r+4)+((s-1)*22);
        subplot(numSubjects,22,ps:(ps+1)); hold on; 
        
        bar(ROWcnt,'stacked');xlim([0.5 7.5]);  
        
        if r==1
            set(gca,'YTick',[0 2 4 6 8 10] ,'YTickLabel',[0 2 4 6 8 10], 'fontsize', 15, 'fontname', 'Corbel');
        else
            set(gca,'YTickLabel',[]);    
        end
        
        if s==1
            title([QSCats{r}, '-II'], 'fontsize', 20, 'fontname', 'Corbel'); 
            set(gca,'XTickLabel',[]); 
        elseif s==5 && r==1
            ylabel(['#'], 'fontsize', 35, 'fontname', 'Corbel')
            set(gca,'XTickLabel',[]); 
        elseif s==9
            set(gca,'XTick',[2 4 6] ,'XTickLabel',[2 4 6], 'fontsize', 15, 'fontname', 'Corbel');
        else
            set(gca,'XTickLabel',[]); 
        end
    end;       
end;

for s=1:numSubjects
    ps=1+((s-1)*22);
    subplot(numSubjects,22,ps:(ps+1)); hold on;
    set(gca,'YTick',[0 5 10] ,'YTickLabel',[0 5 10], 'fontsize', 15, 'fontname', 'Corbel');
    
    if s==1
        title(['I'], 'fontsize', 20, 'fontname', 'Corbel');
        set(gca,'XTickLabel',[]); 
    elseif s==9
        set(gca,'XTick',[0 20 40 60] ,'XTickLabel',[0 20 40 60], 'fontsize', 15, 'fontname', 'Corbel');
    else
        set(gca,'XTickLabel',[]); 
    end
    
    for l=1:7
        loi=find(L(s,:)==l);
        if l<4
            lp='b.-';
        elseif l==4,
            lp='k.-';
        else
            lp='r.-';
        end;
        NRSlevel(l,:)=NRS(s,loi);
        plot(T(s,loi),NRSlevel(l,:),lp);
        axis([0 71 0 10]);
    end;
    EST1(s) = mean(Subject{s}.NRS_EST1);  EST2(s) = mean(Subject{s}.NRS_EST2);
    EPT1(s) = mean(Subject{s}.NRS_EPT1);  EPT2(s) = mean(Subject{s}.NRS_EPT2);
    ETT1(s) = mean(Subject{s}.NRS_ETT1);  ETT2(s) = mean(Subject{s}.NRS_ETT2);
    
    plot([0 71],[mean(Subject{s}.NRS_EST1),mean(Subject{s}.NRS_EST2)],'bo:');
    plot([0 71],[mean(Subject{s}.NRS_EPT1),mean(Subject{s}.NRS_EPT2)],'kx:');
    plot([0 71],[mean(Subject{s}.NRS_ETT1),mean(Subject{s}.NRS_ETT2)],'r*:');
    
    OP = get(gca, 'OuterPosition'); 
    ylabel([num2str(s)], 'fontsize', 40, 'fontweight','bold', 'fontname', 'Corbel', 'Rotation', 0, 'VerticalAlignment', 'middle', 'Position', [OP(1)-60 OP(2)+3.5]);
    
    ps=3+((s-1)*22);
    subplot(numSubjects,22,ps:(ps+1)); hold on;
    set(gca,'YTickLabel',[]); 
    set(gca,'XTickLabel',[]);
    if s==1
        title(['II'], 'fontsize', 20, 'fontname', 'Corbel');
    end
    
    position=get(gca, 'Position');
    boxplot(NRSlevel','colors','bbbkrrr');ylim([0 10]);
    % ^ Always put a break point here and wait for the figure to rescale.
    % Otherwise, one subplot does not fit in well (Dunno why..) 
    x1=xlim();
    plot(x1,mean([Subject{s}.NRS_EST1,Subject{s}.NRS_EST2])*[1,1],'bo:');
    plot(x1,mean([Subject{s}.NRS_EPT1,Subject{s}.NRS_EPT2])*[1,1],'kx:');
    plot(x1,mean([Subject{s}.NRS_ETT1,Subject{s}.NRS_ETT2])*[1,1],'r*:');

    if s==9
        set(gca,'XTick',[2 4 6] ,'XTickLabel',[2 4 6], 'fontsize', 15, 'fontname', 'Corbel');
    else
        set(gca,'XTickLabel',[]);    
    end
    set(gca,'Position',position);
    hold off;
end;

hold off;


