clear all

% load data
Experiment2_ExtractData
numSubjects=length(Subject);

% structure data
for i=1:numSubjects
    Data{1}(i,1) = Subject{i}.EST1_mean;
    Data{1}(i,2) = Subject{i}.EST2_mean;
    Data{2}(i,1) = Subject{i}.EPT1_mean;
    Data{2}(i,2) = Subject{i}.EPT2_mean;    
    Data{3}(i,1) = Subject{i}.ETT1_mean;
    Data{3}(i,2) = Subject{i}.ETT2_mean;    
end

[r.EST, LB.EST, UB.EST, F.EST, df1.EST, df2.EST, p.EST] = ICC(Data{1}, 'A-1');
[r.EPT, LB.EPT, UB.EPT, F.EPT, df1.EPT, df2.EPT, p.EPT] = ICC(Data{2}, 'A-1');
[r.ETT, LB.ETT, UB.ETT, F.ETT, df1.ETT, df2.ETT, p.ETT] = ICC(Data{3}, 'A-1');

figdata.title = ['Individual responses to the DT, PT and PTT'];
figdata.xlabel = '';
figdata.ylabel = 'Electrical current [mA]';
figdata.xticklabels = {'Detection Threshold','Pain Threshold','Pain Tolerance Threshold'};

trt_plot_alternating_noBA(Data,1,figdata);

[h1, p1, ci1, stats1] = ttest(Data{1}(:,1), Data{1}(:,2));
[h2, p2, ci2, stats2] = ttest(Data{2}(:,1), Data{2}(:,2));
[h3, p3, ci3, stats3] = ttest(Data{3}(:,1), Data{3}(:,2));