% Extract Data Marjolein Thijssen

clear all;
close all;

% Extract Subject datasheets
fname='... \Datasets\Dataset - Experiment 2 - Condensed.xlsx';
[dummy,Subject_sheets] = xlsfinfo(fname);
clear dummy;
Subject_sheets=Subject_sheets(find(cellfun(@(x) length(x),Subject_sheets)==2));

% Extract Subject data
for s=1:length(Subject_sheets)
    
    % Extract Initial Thresholds and  associated NRS values
    data=xlsread(fname,Subject_sheets{s},'B3:G5');
    Subject{s}.ID=Subject_sheets{s};
    Subject{s}.EST1=data(1,1:2:5);
    Subject{s}.EPT1=data(2,1:2:5);
    Subject{s}.ETT1=data(3,1:2:5);
    Subject{s}.NRS_EST1=data(1,2:2:6);
    Subject{s}.NRS_EPT1=data(2,2:2:6);
    Subject{s}.NRS_ETT1=data(3,2:2:6);
    Subject{s}.EST1_mean=mean(Subject{s}.EST1);
    Subject{s}.EPT1_mean=mean(Subject{s}.EPT1);
    Subject{s}.ETT1_mean=mean(Subject{s}.ETT1);
    Subject{s}.EST1_std=std(Subject{s}.EST1);
    Subject{s}.EPT1_std=std(Subject{s}.EPT1);
    Subject{s}.ETT1_std=std(Subject{s}.ETT1);
    
    % Extract test intensities
    data=xlsread(fname,Subject_sheets{1},'C13:C19');
    Subject{s}.T=data';
    
    % Extract Qscale and NRS reports
    [data,text]=xlsread(fname,Subject_sheets{s},'A22:G91');
    Subject{s}.Exp_T=[1:size(data,1)]';
    Subject{s}.Exp_L=cellfun(@(x) sscanf(x(2),'%d'),text);
    Subject{s}.Exp_A=data(:,1);
    Subject{s}.Exp_NRS=data(:,2);
    Subject{s}.Exp_ROW=data(:,3:6);
    
    % Extract Final Thresholds and  associated NRS values
    data=xlsread(fname,Subject_sheets{s},'B94:G96');
    Subject{s}.EST2=data(1,1:2:5);
    Subject{s}.EPT2=data(2,1:2:5);
    Subject{s}.ETT2=data(3,1:2:5);
    Subject{s}.NRS_EST2=data(1,2:2:6);
    Subject{s}.NRS_EPT2=data(2,2:2:6);
    Subject{s}.NRS_ETT2=data(3,2:2:6);
    Subject{s}.EST2_mean=mean(Subject{s}.EST2);
    Subject{s}.EPT2_mean=mean(Subject{s}.EPT2);
    Subject{s}.ETT2_mean=mean(Subject{s}.ETT2);
    Subject{s}.EST2_std=std(Subject{s}.EST2);
    Subject{s}.EPT2_std=std(Subject{s}.EPT2);
    Subject{s}.ETT2_std=std(Subject{s}.ETT2);
    
    
end;

% clean up 
clear Subject_sheets data text s

% Save data
% save BScMarjoleinThijssen9


