# Raquel Viula, 2022
# "Discomfort Glare in Classrooms: an Investigation in Space"
# PhD Thesis, TU Delft

# analyse power of regression of optimised model
# reference:
# https://stats.stackexchange.com/questions/523092/numerator-degrees-of-freedom-in-power-analysis-for-regression-r-vs-gpower

#### load required libraries ####
library(pwr)

# identify working directory (of R project)
setwd("~/glare-spatial-model")
wd <- getwd()


#### power analysis ####
# u is the number of predictors
model_u = c(1,2,3,4)
# n is the sample size
model_n = c(10,14)
# v = n - u - 1
# f2 is the effect size
model_r2 = c(0.72, 0.81, 0.93, 0.86,0.76,0.85,0.92)
# significance of the 
model_sig = c(0.05,0.01,0.001)

#
# power analysis results dataframe
power_analysis = data.frame(
  r2=double(),
  f2=double(),
  n=integer(),
  u=integer(),
  v=integer(),
  sig=double(),
  power=double(),
  stringsAsFactors=FALSE
)
# write the headers
write.csv(power_analysis,file=paste0(wd,"/outputs/ch9/power_analysis.csv"),row.names=F)
#
# loop for power effect
for (r2 in model_r2){
  for (n in model_n){
    for (u in model_u){
      for (sig in model_sig){
        f2 <- r2/(1-r2)
        v <- n - u - 1
        test <- pwr.f2.test(u=u, v=v, f2=f2, sig.level=sig)
        power <- test[[5]]
        # write data results
        df_res = data.frame(r2, f2, n, u, v, sig = sig, power = power)
        write.table(df_res,file=paste0(wd,"/outputs/ch9/power_analysis.csv"),sep = ",",append=T,col.names=F,row.names=F)
      }
    }
  }
}


#### sample analysis ####
# u is the number of predictors
model_u = c(3)
# n is the sample size
# v = n - u - 1
# n = v + u + 1
# f2 is the effect size
model_r2 = c(0.91, 0.84)
# significance
model_sig = c(0.05,0.01,0.001)
# power
model_power = c(0.8,0.6,0.5)

#
# sample analysis results dataframe
sample_analysis = data.frame(
  r2=double(),
  f2=double(),
  power=double(),
  u=integer(),
  v=integer(),
  sig=double(),
  n=integer(),
  stringsAsFactors=FALSE
)
# write the headers
write.csv(sample_analysis,file=paste0(getwd(),"/outputs/ch9/sample_analysis.csv"),row.names=F)
#
# loop for sample size
for (r2 in model_r2){
  for (power in model_power){
    for (u in model_u){
      for (sig in model_sig){
        f2 <- r2/(1-r2)
        test <- pwr.f2.test(u=u, f2=f2, sig.level=sig, power=power)
        v <- test[[2]]
        n <- v + u + 1
        # write data results
        df_res = data.frame(r2, f2, power, u, v, sig, n)
        write.table(df_res,file=paste0(getwd(),"/outputs/ch9/sample_analysis.csv"),sep = ",",append=T,col.names=F,row.names=F)
      }
    }
  }
}
