# Raquel Viula, 2022
# "Discomfort Glare in Classrooms: an Investigation in Space"
# PhD Thesis, TU Delft

# exploring parameters using spearman correlation


#### load required libraries ####
library("RVAideMemoire") # for spearman ci

# identify working directory (of R project)
setwd("~/glare-spatial-model")
wd <- getwd()


#
#### calculate spearman ####
#
spearman_plots <- function(df, fl){
  for (ind in c(1:length(inds))){
    x=df[,inds[ind]]
    pref = 'spearman: '
    suff = ''
    corr_df = cor.test(x, df$vote, method = "spearman")
    val_rho = corr_df$estimate
    val_p = corr_df$p.value
    val_ci = spearman.ci(x, df$vote, nrep = 1000, conf.level = 0.95)[[6]]
    ci_upper = val_ci[2]
    ci_lower = val_ci[1]
    # plot
    plot(x, df$vote, pch = 16, cex = 1.3, col = colour, xlab = names(inds[ind]), ylab = 'Vote', 
         main = bquote('rho' == .(val_rho) ~ ", p-value: " ~ .(val_p)))
    # results
    res <- data.frame(fl,names(inds[ind]),'spearman',val_rho,val_p,ci_upper,ci_lower)
    write.table(res,file=paste0(getwd(),"/outputs/ch7/parameters_spearman.csv"),sep = ",",append=T,col.names=F,row.names=F)
  }
  plot.new()
}
# results dataframe
spearman_results = data.frame(
  position=character(),
  parameter=character(),
  transformation=character(),
  rho=double(),
  p=double(),
  ci_upper=double(),
  ci_lower=double(),
  stringsAsFactors=FALSE
)
# write the headers
write.csv(spearman_results,file=paste0(getwd(),"/outputs/ch7/parameters_spearman.csv"),col.names=T,row.names=F)
# full data
fl = "full"
df = vote_data
spearman_plots(df,fl)
# p1 data
fl = "p1"
df = p1_vote_data
spearman_plots(df,fl)
# p2 data
fl = "p2"
df = p2_vote_data
spearman_plots(df,fl)
# p3 data
fl = "p3"
df = p3_vote_data
spearman_plots(df,fl)
# p4 data
fl = "p4"
df = p4_vote_data
spearman_plots(df,fl)
# fromt data
fl = "front"
df = front_vote_data
spearman_plots(df,fl)
# back data
fl = "back"
df = back_vote_data
spearman_plots(df,fl)
# window data
fl = "window"
df = window_vote_data
spearman_plots(df,fl)
# wall data
fl = "wall"
df = wall_vote_data
spearman_plots(df,fl)


# clean up
rm(fl,df,colours_pos,spearman_results)
