# Raquel Viula, 2022
# "Discomfort Glare in Classrooms: an Investigation in Space"
# PhD Thesis, TU Delft

# produce ROC curves instead of regression models

#### load required libraries ####
library("ROCit")
library("verification")

# identify working directory (of R project)
setwd("~/glare-spatial-model")
wd <- getwd()

#
#### calculate ROC curve for every glare parameter against disturbing/any glare #### 
#
roc_plots <- function(df,fl,inds,csv){
  for (ind in inds){
    for (glare in glares){
      # calculate ROC for glare
      roc <- rocit(score = df[,ind], class = df[,glare]) 
      roc_df <- as.data.frame(cbind(Cutoff=roc$Cutoff, TPR=roc$TPR, FPR=roc$FPR))
      # make the ROC plot
      plot(roc, values = F, legend = F, YIndex = F)
      title(main = bquote("Pos: " ~ .(fl) ~ "  P: " ~ .(names(which(inds==ind))) ~ "  G: " ~ .(glare)))
      
      # extract ROC values to add to the results
      # calculate AUC confidence intervals
      AUC_ci = ciAUC(roc)
      AUC = AUC_ci[[1]]
      AUC_ci_lower = AUC_ci[[5]]
      AUC_ci_upper = AUC_ci[[6]]
      AUC_p = roc.area(df[,glare], df[,ind])$p.value
      # calculate minimum distance
      roc_df$SQRdist <- sqrt((1- roc_df$TPR)^2+(roc_df$FPR)^2)
      roc_min = roc_df[roc_df$SQRdist == min(roc_df$SQRdist),]
      min_dist = roc_min$SQRdist
      min_dist_TPR = roc_min$TPR
      min_dist_TNR = (1-roc_min$FPR)
      # add row to results
      res <- data.frame(fl,names(which(inds==ind)),glare,AUC,AUC_ci_lower,AUC_ci_upper,AUC_p,roc_min$Cutoff,min_dist,min_dist_TPR,min_dist_TNR)
      write.table(res,file=paste0(wd,csv),sep = ",",append=T,col.names=F,row.names=F)
    }
  }
}
# results dataframe
ROC_parameters_results = data.frame(
  position=character(),
  parameter=character(),
  glare=character(),
  AUC=double(),
  AUC_ci_lower=double(),
  AUC_ci_upper=double(),
  AUC_p=double(),
  cutoff=double(),
  min_dist=double(),
  min_dist_TPR=double(),
  min_dist_TNR=double(),
  stringsAsFactors=FALSE
)
# write the headers
csv = "/outputs/ch7/parameters_glare_roc.csv"
write.csv(ROC_parameters_results,file=paste0(wd,csv),col.names=T,row.names=F)
# full data
fl = "full"
df = vote_data
roc_plots(df,fl,inds,csv)
# p1 data
fl = "p1"
df = p1_vote_data
roc_plots(df,fl,inds,csv)
# p2 data
fl = "p2"
df = p2_vote_data
roc_plots(df,fl,inds,csv)
# p3 data
fl = "p3"
df = p3_vote_data
roc_plots(df,fl,inds,csv)
# p4 data
fl = "p4"
df = p4_vote_data
roc_plots(df,fl,inds,csv)
# front data
fl = "front"
df = front_vote_data
roc_plots(df,fl,inds,csv)
# back data
fl = "back"
df = back_vote_data
roc_plots(df,fl,inds,csv)
# wall data
fl = "wall"
df = wall_vote_data
roc_plots(df,fl,inds,csv)
# window data
fl = "window"
df = window_vote_data
roc_plots(df,fl,inds,csv)

# clean up
rm(fl,df,ROC_parameters_results)



